/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.subscriber;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.mapper.event.dcl.impl.CreateUserStatementEvent;
import org.apache.shardingsphere.infra.metadata.mapper.event.dcl.impl.DropUserStatementEvent;
import org.apache.shardingsphere.infra.metadata.mapper.event.dcl.impl.GrantStatementEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.user.service.UserStatusService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.GlobalRulePersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class GlobalRuleRegistrySubscriber {
    private final GlobalRulePersistService persistService;
    private final UserStatusService userStatusService;

    public GlobalRuleRegistrySubscriber(ClusterPersistRepository repository) {
        this.persistService = new GlobalRulePersistService((PersistRepository)repository);
        this.userStatusService = new UserStatusService(repository);
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(CreateUserStatementEvent event) {
        Collection globalRuleConfigs = this.persistService.load();
        Optional<AuthorityRuleConfiguration> authorityRuleConfig = globalRuleConfigs.stream().filter(each -> each instanceof AuthorityRuleConfiguration).findAny().map(each -> (AuthorityRuleConfiguration)each);
        Preconditions.checkState((boolean)authorityRuleConfig.isPresent(), (Object)"No available authority rules for governance.");
        authorityRuleConfig.get().getUsers().addAll(event.getUsers());
        this.persistService.persist(globalRuleConfigs, true);
    }

    @Subscribe
    public void update(DropUserStatementEvent event) {
        Collection globalRuleConfigs = this.persistService.load();
        Optional<AuthorityRuleConfiguration> authorityRuleConfig = globalRuleConfigs.stream().filter(each -> each instanceof AuthorityRuleConfiguration).findAny().map(each -> (AuthorityRuleConfiguration)each);
        Preconditions.checkState((boolean)authorityRuleConfig.isPresent(), (Object)"No available authority rules for governance.");
        authorityRuleConfig.get().getUsers().removeIf(each -> event.getUsers().contains(each.getGrantee().getUsername()));
        this.persistService.persist(globalRuleConfigs, true);
    }

    @Subscribe
    public void update(GrantStatementEvent event) {
        if (!event.getUsers().isEmpty()) {
            this.userStatusService.persist(event.getUsers());
        }
    }
}

