/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.event.LockNotificationEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.event.LockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class LockChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(LockNode.getLockRootNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (!event.getKey().equals(LockNode.getLockRootNodePath()) && LockNode.getLockName(event.getKey()).isPresent()) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                return Optional.of(new LockNotificationEvent(LockNode.getLockName(event.getKey()).get()));
            }
            if (DataChangedEvent.Type.DELETED == event.getType()) {
                return Optional.of(new LockReleasedEvent(LockNode.getLockName(event.getKey()).get()));
            }
        }
        return Optional.empty();
    }
}

