/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilder;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.optimize.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.authority.event.AuthorityChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterContextManagerCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterContextManagerCoordinator.class);
    private final MetaDataPersistService metaDataPersistService;
    private final ContextManager contextManager;

    public ClusterContextManagerCoordinator(MetaDataPersistService metaDataPersistService, ContextManager contextManager) {
        this.metaDataPersistService = metaDataPersistService;
        this.contextManager = contextManager;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) throws SQLException {
        this.persistSchema(event.getSchemaName());
        this.contextManager.addSchema(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        this.contextManager.deleteSchema(event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        ConfigurationProperties props = new ConfigurationProperties(event.getProps());
        this.contextManager.renewMetaDataContexts(this.rebuildMetaDataContexts(props));
    }

    @Subscribe
    public synchronized void renew(AuthorityChangedEvent event) {
        Optional<AuthorityRule> rule = this.contextManager.getMetaDataContexts().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof AuthorityRule).findAny().map(each -> (AuthorityRule)each);
        rule.ifPresent(optional -> optional.refresh(this.contextManager.getMetaDataContexts().getMetaDataMap(), event.getUsers()));
    }

    @Subscribe
    public synchronized void renew(SchemaChangedEvent event) {
        String schemaName = event.getSchemaName();
        Collection tableMetaDataList = event.getSchema().getTables().values();
        ShardingSphereMetaData kernelMetaData = new ShardingSphereMetaData(schemaName, this.contextManager.getMetaDataContexts().getMetaData(schemaName).getResource(), this.contextManager.getMetaDataContexts().getMetaData(schemaName).getRuleMetaData(), SchemaBuilder.buildKernelSchema(tableMetaDataList, (Collection)this.contextManager.getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getRules()));
        HashMap<String, ShardingSphereMetaData> kernelMetaDataMap = new HashMap<String, ShardingSphereMetaData>(this.contextManager.getMetaDataContexts().getMetaDataMap());
        kernelMetaDataMap.put(schemaName, kernelMetaData);
        this.contextManager.getMetaDataContexts().getOptimizerContext().getMetaData().getSchemas().put(schemaName, new FederationSchemaMetaData(schemaName, SchemaBuilder.buildFederationSchema(tableMetaDataList, (Collection)this.contextManager.getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getRules()).getTables()));
        this.contextManager.renewMetaDataContexts(this.rebuildMetaDataContexts(kernelMetaDataMap));
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        MetaDataContexts changedMetaDataContexts = this.buildChangedMetaDataContext((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(schemaName), event.getRuleConfigurations());
        this.contextManager.getMetaDataContexts().getOptimizerContext().getMetaData().getSchemas().putAll(changedMetaDataContexts.getOptimizerContext().getMetaData().getSchemas());
        HashMap<String, ShardingSphereMetaData> metaDataMap = new HashMap<String, ShardingSphereMetaData>(this.contextManager.getMetaDataContexts().getMetaDataMap());
        metaDataMap.putAll(changedMetaDataContexts.getMetaDataMap());
        this.contextManager.renewMetaDataContexts(this.rebuildMetaDataContexts(metaDataMap));
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) throws SQLException {
        String schemaName = event.getSchemaName();
        MetaDataContexts changedMetaDataContext = this.buildChangedMetaDataContext((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(schemaName), event.getDataSourceConfigurations());
        this.contextManager.getMetaDataContexts().getOptimizerContext().getMetaData().getSchemas().putAll(changedMetaDataContext.getOptimizerContext().getMetaData().getSchemas());
        HashMap<String, ShardingSphereMetaData> metaDataMap = new HashMap<String, ShardingSphereMetaData>(this.contextManager.getMetaDataContexts().getMetaDataMap());
        metaDataMap.putAll(changedMetaDataContext.getMetaDataMap());
        Collection<DataSource> pendingClosedDataSources = this.getPendingClosedDataSources(schemaName, event.getDataSourceConfigurations());
        this.contextManager.renewMetaDataContexts(this.rebuildMetaDataContexts(metaDataMap));
        this.renewTransactionContext(schemaName, this.contextManager.getMetaDataContexts().getMetaData(schemaName).getResource());
        this.closeDataSources(schemaName, pendingClosedDataSources);
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent event) {
        QualifiedSchema qualifiedSchema = event.getQualifiedSchema();
        ((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(qualifiedSchema.getSchemaName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(qualifiedSchema.getDataSourceName(), event.isDisabled())));
    }

    @Subscribe
    public synchronized void renew(PrimaryStateChangedEvent event) {
        QualifiedSchema qualifiedSchema = event.getQualifiedSchema();
        ((ShardingSphereMetaData)this.contextManager.getMetaDataContexts().getMetaDataMap().get(qualifiedSchema.getSchemaName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new PrimaryDataSourceChangedEvent(qualifiedSchema.getSchemaName(), qualifiedSchema.getDataSourceName(), event.getPrimaryDataSourceName())));
    }

    @Subscribe
    public synchronized void renew(GlobalRuleConfigurationsChangedEvent event) {
        Collection<RuleConfiguration> newGlobalConfigs = event.getRuleConfigurations();
        if (!newGlobalConfigs.isEmpty()) {
            ShardingSphereRuleMetaData newGlobalRuleMetaData = new ShardingSphereRuleMetaData(newGlobalConfigs, GlobalRulesBuilder.buildRules(newGlobalConfigs, (Map)this.contextManager.getMetaDataContexts().getMetaDataMap()));
            this.contextManager.renewMetaDataContexts(this.rebuildMetaDataContexts(newGlobalRuleMetaData));
        }
    }

    private MetaDataContexts rebuildMetaDataContexts(Map<String, ShardingSphereMetaData> schemaMetaData) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaDataPersistService().isPresent());
        return new MetaDataContexts((MetaDataPersistService)this.contextManager.getMetaDataContexts().getMetaDataPersistService().get(), schemaMetaData, this.contextManager.getMetaDataContexts().getGlobalRuleMetaData(), this.contextManager.getMetaDataContexts().getExecutorEngine(), this.contextManager.getMetaDataContexts().getProps(), this.contextManager.getMetaDataContexts().getOptimizerContext());
    }

    private MetaDataContexts rebuildMetaDataContexts(ConfigurationProperties props) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaDataPersistService().isPresent());
        return new MetaDataContexts((MetaDataPersistService)this.contextManager.getMetaDataContexts().getMetaDataPersistService().get(), this.contextManager.getMetaDataContexts().getMetaDataMap(), this.contextManager.getMetaDataContexts().getGlobalRuleMetaData(), this.contextManager.getMetaDataContexts().getExecutorEngine(), props, this.contextManager.getMetaDataContexts().getOptimizerContext());
    }

    private MetaDataContexts rebuildMetaDataContexts(ShardingSphereRuleMetaData globalRuleMetaData) {
        Preconditions.checkState((boolean)this.contextManager.getMetaDataContexts().getMetaDataPersistService().isPresent());
        return new MetaDataContexts((MetaDataPersistService)this.contextManager.getMetaDataContexts().getMetaDataPersistService().get(), this.contextManager.getMetaDataContexts().getMetaDataMap(), globalRuleMetaData, this.contextManager.getMetaDataContexts().getExecutorEngine(), this.contextManager.getMetaDataContexts().getProps(), this.contextManager.getMetaDataContexts().getOptimizerContext());
    }

    private void persistSchema(String schemaName) {
        if (!this.metaDataPersistService.getDataSourceService().isExisted(schemaName)) {
            this.metaDataPersistService.getDataSourceService().persist(schemaName, new LinkedHashMap());
        }
        if (!this.metaDataPersistService.getSchemaRuleService().isExisted(schemaName)) {
            this.metaDataPersistService.getSchemaRuleService().persist(schemaName, new LinkedList());
        }
    }

    private MetaDataContexts buildChangedMetaDataContext(ShardingSphereMetaData originalMetaData, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        Map<String, Map> dataSourcesMap = Collections.singletonMap(originalMetaData.getName(), originalMetaData.getResource().getDataSources());
        Map<String, Collection<RuleConfiguration>> schemaRuleConfigs = Collections.singletonMap(originalMetaData.getName(), ruleConfigs);
        Properties props = this.contextManager.getMetaDataContexts().getProps().getProps();
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)props);
        Map schemas = new SchemaLoader(dataSourcesMap, schemaRuleConfigs, rules, props).load();
        this.metaDataPersistService.getSchemaMetaDataService().persist(originalMetaData.getName(), (ShardingSphereSchema)schemas.get(originalMetaData.getName()));
        return new MetaDataContextsBuilder(dataSourcesMap, schemaRuleConfigs, this.metaDataPersistService.getGlobalRuleService().load(), schemas, rules, props).build(this.metaDataPersistService);
    }

    private MetaDataContexts buildChangedMetaDataContext(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) throws SQLException {
        Set<String> deletedDataSources = this.getDeletedDataSources(originalMetaData, newDataSourceConfigs).keySet();
        Map<String, DataSource> changedDataSources = this.buildChangedDataSources(originalMetaData, newDataSourceConfigs);
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(originalMetaData.getName(), this.getNewDataSources(originalMetaData.getResource().getDataSources(), this.getAddedDataSources(originalMetaData, newDataSourceConfigs), changedDataSources, deletedDataSources));
        Map<String, Collection> schemaRuleConfigs = Collections.singletonMap(originalMetaData.getName(), originalMetaData.getRuleMetaData().getConfigurations());
        Properties props = this.contextManager.getMetaDataContexts().getProps().getProps();
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)props);
        Map schemas = new SchemaLoader(dataSourcesMap, schemaRuleConfigs, rules, props).load();
        this.metaDataPersistService.getSchemaMetaDataService().persist(originalMetaData.getName(), (ShardingSphereSchema)schemas.get(originalMetaData.getName()));
        return new MetaDataContextsBuilder(dataSourcesMap, schemaRuleConfigs, this.metaDataPersistService.getGlobalRuleService().load(), schemas, rules, props).build(this.metaDataPersistService);
    }

    private Map<String, DataSource> getNewDataSources(Map<String, DataSource> originalDataSources, Map<String, DataSource> addedDataSources, Map<String, DataSource> changedDataSources, Collection<String> deletedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(originalDataSources);
        result.keySet().removeAll(deletedDataSources);
        result.putAll(changedDataSources);
        result.putAll(addedDataSources);
        return result;
    }

    private Map<String, DataSource> getDeletedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> !newDataSourceConfigs.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getChangedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        Set<String> changedDataSourceNames = this.getChangedDataSourceConfiguration(originalMetaData, newDataSourceConfigs).keySet();
        return originalMetaData.getResource().getDataSources().entrySet().stream().filter(entry -> changedDataSourceNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, DataSource> getAddedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        return DataSourceConverter.getDataSourceMap((Map)Maps.filterKeys(newDataSourceConfigs, each -> !originalMetaData.getResource().getDataSources().containsKey(each)));
    }

    private Map<String, DataSourceConfiguration> getChangedDataSourceConfiguration(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        return dataSourceConfigurations.entrySet().stream().filter(entry -> this.isModifiedDataSource(originalMetaData.getResource().getDataSources(), (String)entry.getKey(), (DataSourceConfiguration)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, DataSource> buildChangedDataSources(ShardingSphereMetaData originalMetaData, Map<String, DataSourceConfiguration> newDataSourceConfigs) {
        return DataSourceConverter.getDataSourceMap(this.getChangedDataSourceConfiguration(originalMetaData, newDataSourceConfigs));
    }

    private boolean isModifiedDataSource(Map<String, DataSource> originalDataSources, String dataSourceName, DataSourceConfiguration dataSourceConfiguration) {
        DataSourceConfiguration dataSourceConfig = (DataSourceConfiguration)DataSourceConverter.getDataSourceConfigurationMap(originalDataSources).get(dataSourceName);
        return null != dataSourceConfig && !dataSourceConfiguration.equals((Object)dataSourceConfig);
    }

    private Collection<DataSource> getPendingClosedDataSources(String schemaName, Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        LinkedList<DataSource> result = new LinkedList<DataSource>();
        result.addAll(this.getDeletedDataSources(this.contextManager.getMetaDataContexts().getMetaData(schemaName), dataSourceConfigurations).values());
        result.addAll(this.getChangedDataSources(this.contextManager.getMetaDataContexts().getMetaData(schemaName), dataSourceConfigurations).values());
        return result;
    }

    private void closeDataSources(String schemaName, Collection<DataSource> dataSources) {
        ShardingSphereResource resource = this.contextManager.getMetaDataContexts().getMetaData(schemaName).getResource();
        dataSources.forEach(each -> this.closeDataSource(resource, (DataSource)each));
    }

    private void closeDataSource(ShardingSphereResource resource, DataSource dataSource) {
        try {
            resource.close(dataSource);
        }
        catch (SQLException ex) {
            log.error("Close data source failed", (Throwable)ex);
        }
    }

    private void renewTransactionContext(String schemaName, ShardingSphereResource resource) {
        this.closeStaleEngine(schemaName);
        Map existedEngines = this.contextManager.getTransactionContexts().getEngines();
        existedEngines.put(schemaName, this.createNewEngine(resource.getDatabaseType(), resource.getDataSources()));
        this.renewContexts(existedEngines);
    }

    private void closeStaleEngine(String schemaName) {
        ShardingSphereTransactionManagerEngine staleEngine = (ShardingSphereTransactionManagerEngine)this.contextManager.getTransactionContexts().getEngines().remove(schemaName);
        if (null != staleEngine) {
            try {
                staleEngine.close();
            }
            catch (Exception ex) {
                log.error("Close transaction engine failed", (Throwable)ex);
            }
        }
    }

    private ShardingSphereTransactionManagerEngine createNewEngine(DatabaseType databaseType, Map<String, DataSource> dataSources) {
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine();
        result.init(databaseType, dataSources, this.getTransactionRule());
        return result;
    }

    private TransactionRule getTransactionRule() {
        Optional<TransactionRule> transactionRule = this.contextManager.getMetaDataContexts().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    private void renewContexts(Map<String, ShardingSphereTransactionManagerEngine> engines) {
        this.contextManager.renewTransactionContexts(new TransactionContexts(engines));
    }
}

