/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.transaction;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.BackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackToSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TransactionBackendHandler
implements TextProtocolBackendHandler {
    private final TCLStatement tclStatement;
    private final TransactionOperationType operationType;
    private final BackendTransactionManager backendTransactionManager;

    public TransactionBackendHandler(TCLStatement tclStatement, TransactionOperationType operationType, BackendConnection backendConnection) {
        this.tclStatement = tclStatement;
        this.operationType = operationType;
        this.backendTransactionManager = new BackendTransactionManager(backendConnection);
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        switch (this.operationType) {
            case BEGIN: {
                this.backendTransactionManager.begin();
                break;
            }
            case SAVEPOINT: {
                this.backendTransactionManager.setSavepoint(((SavepointStatement)this.tclStatement).getSavepointName());
                break;
            }
            case ROLLBACK_TO_SAVEPOINT: {
                this.backendTransactionManager.rollbackTo(((RollbackToSavepointStatement)this.tclStatement).getSavepointName());
                break;
            }
            case RELEASE_SAVEPOINT: {
                this.backendTransactionManager.releaseSavepoint(((ReleaseSavepointStatement)this.tclStatement).getSavepointName());
                break;
            }
            case COMMIT: {
                this.backendTransactionManager.commit();
                break;
            }
            case ROLLBACK: {
                this.backendTransactionManager.rollback();
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(this.operationType.name());
            }
        }
        return new UpdateResponseHeader((SQLStatement)this.tclStatement);
    }
}

