/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.singletable.rule.SingleTableDataNode;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SingleTableRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<SingleTableDataNode> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        ShowSingleTableRulesStatement showSingleTableRulesStatement = (ShowSingleTableRulesStatement)sqlStatement;
        Stream<SingleTableDataNode> singleTableRules = metaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof SingleTableRule).map(each -> (SingleTableRule)each).map(each -> each.getSingleTableDataNodes().entrySet()).flatMap(Collection::stream).map(Map.Entry::getValue);
        if (null != showSingleTableRulesStatement.getTableName()) {
            singleTableRules = singleTableRules.filter(each -> showSingleTableRulesStatement.getTableName().equals(each.getTableName()));
        }
        this.data = singleTableRules.collect(Collectors.toCollection(LinkedList::new)).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table_name", "resource_name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        SingleTableDataNode next = this.data.next();
        return Arrays.asList(next.getTableName(), next.getDataSourceName());
    }

    public String getType() {
        return ShowSingleTableRulesStatement.class.getCanonicalName();
    }
}

