/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.SchemaRequiredBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class RQLBackendHandler
extends SchemaRequiredBackendHandler<RQLStatement> {
    private final DistSQLResultSet resultSet;

    public RQLBackendHandler(RQLStatement sqlStatement, BackendConnection backendConnection, DistSQLResultSet resultSet) {
        super(sqlStatement, backendConnection);
        this.resultSet = resultSet;
    }

    @Override
    protected ResponseHeader execute(String schemaName, RQLStatement sqlStatement) {
        this.resultSet.init(ProxyContext.getInstance().getMetaData(schemaName), (SQLStatement)sqlStatement);
        List<QueryHeader> queryHeaders = this.resultSet.getColumnNames().stream().map(each -> new QueryHeader(schemaName, "", (String)each, (String)each, 1, "CHAR", 255, 0, false, false, false, false)).collect(Collectors.toList());
        return new QueryResponseHeader(queryHeaders);
    }

    @Override
    public boolean next() {
        return this.resultSet.next();
    }

    @Override
    public Collection<Object> getRowData() {
        return this.resultSet.getRowData();
    }
}

