/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;

public final class DataSourceQueryResultSetConverter {
    public static Map<String, DataSourceParameter> covert(Map<String, DataSourceConfiguration> dataSourceConfigMap) {
        return dataSourceConfigMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceQueryResultSetConverter.covert((DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static DataSourceParameter covert(DataSourceConfiguration dataSourceConfig) {
        DataSourceQueryResultSetConverter.bindSynonym(dataSourceConfig);
        DataSourceParameter result = new DataSourceParameter();
        for (Field each : result.getClass().getDeclaredFields()) {
            try {
                Properties dataSourceConfigProp;
                Properties properties = dataSourceConfigProp = "customPoolProps".equals(each.getName()) ? dataSourceConfig.getCustomPoolProps() : dataSourceConfig.getProps().get(each.getName());
                if (null == dataSourceConfigProp) continue;
                each.setAccessible(true);
                DataSourceQueryResultSetConverter.setDataSourceParameterField(each, result, dataSourceConfigProp);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return result;
    }

    private static void bindSynonym(DataSourceConfiguration dataSourceConfig) {
        dataSourceConfig.addPropertySynonym("url", "jdbcUrl");
        dataSourceConfig.addPropertySynonym("user", "username");
        dataSourceConfig.addPropertySynonym("connectionTimeout", "connectionTimeoutMilliseconds");
        dataSourceConfig.addPropertySynonym("maxLifetime", "maxLifetimeMilliseconds");
        dataSourceConfig.addPropertySynonym("idleTimeout", "idleTimeoutMilliseconds");
        dataSourceConfig.addPropertySynonym("maxPoolSize", "maximumPoolSize");
        dataSourceConfig.addPropertySynonym("minPoolSize", "minimumIdle");
    }

    private static void setDataSourceParameterField(Field field, DataSourceParameter object, Object value) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            field.set(object, Integer.parseInt(value.toString()));
        } else if (fieldType == Long.TYPE) {
            field.set(object, Long.parseLong(value.toString()));
        } else if (fieldType == Boolean.TYPE) {
            field.set(object, Boolean.parseBoolean(value.toString()));
        } else if (fieldType == String.class) {
            field.set(object, value.toString());
        } else {
            field.set(object, value);
        }
    }

    @Generated
    private DataSourceQueryResultSetConverter() {
    }
}

