/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.distsql.rql.DataSourceQueryResultSetConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DataSourceQueryResultSet
implements DistSQLResultSet {
    private Map<String, DataSourceParameter> dataSourceParameterMap;
    private Iterator<String> dataSourceNames;
    private ShardingSphereResource resource;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        this.resource = metaData.getResource();
        Optional persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService();
        Map dataSourceConfigs = persistService.isPresent() ? ((MetaDataPersistService)persistService.get()).getDataSourceService().load(metaData.getName()) : DataSourceConverter.getDataSourceConfigurationMap((Map)metaData.getResource().getDataSources());
        this.dataSourceParameterMap = DataSourceQueryResultSetConverter.covert(dataSourceConfigs);
        this.dataSourceNames = this.dataSourceParameterMap.keySet().iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "host", "port", "db", "attribute");
    }

    public boolean next() {
        return this.dataSourceNames.hasNext();
    }

    public Collection<Object> getRowData() {
        String dataSourceName = this.dataSourceNames.next();
        DataSourceMetaData dataSourceMetaData = this.resource.getDataSourcesMetaData().getDataSourceMetaData(dataSourceName);
        String type = this.resource.getDatabaseType().getName();
        String host = dataSourceMetaData.getHostName();
        int port = dataSourceMetaData.getPort();
        String db = dataSourceMetaData.getCatalog();
        return Arrays.asList(dataSourceName, type, host, port, db, new Gson().toJson(this.getAttributeMap(this.dataSourceParameterMap.get(dataSourceName))));
    }

    private Map<Object, Object> getAttributeMap(DataSourceParameter dataSourceParameter) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(7, 1.0f);
        result.put("connectionTimeoutMilliseconds", dataSourceParameter.getConnectionTimeoutMilliseconds());
        result.put("idleTimeoutMilliseconds", dataSourceParameter.getIdleTimeoutMilliseconds());
        result.put("maxLifetimeMilliseconds", dataSourceParameter.getMaxLifetimeMilliseconds());
        result.put("maxPoolSize", dataSourceParameter.getMaxPoolSize());
        result.put("minPoolSize", dataSourceParameter.getMinPoolSize());
        result.put("readOnly", dataSourceParameter.isReadOnly());
        if (null != dataSourceParameter.getCustomPoolProps() && !dataSourceParameter.getCustomPoolProps().isEmpty()) {
            result.put("customPoolProps", dataSourceParameter.getCustomPoolProps());
        }
        return result;
    }

    public String getType() {
        return ShowResourcesStatement.class.getCanonicalName();
    }
}

