/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.preprocess.RuleDefinitionAlterPreprocessor;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.SchemaRequiredBackendHandler;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class RuleDefinitionBackendHandler<T extends RuleDefinitionStatement>
extends SchemaRequiredBackendHandler<T> {
    public RuleDefinitionBackendHandler(T sqlStatement, BackendConnection backendConnection) {
        super(sqlStatement, backendConnection);
    }

    @Override
    protected ResponseHeader execute(String schemaName, T sqlStatement) throws DistSQLException {
        RuleDefinitionUpdater ruleDefinitionUpdater = (RuleDefinitionUpdater)TypedSPIRegistry.getRegisteredService(RuleDefinitionUpdater.class, (String)sqlStatement.getClass().getCanonicalName(), (Properties)new Properties());
        Class ruleConfigClass = ruleDefinitionUpdater.getRuleConfigurationClass();
        ShardingSphereMetaData shardingSphereMetaData = ProxyContext.getInstance().getMetaData(schemaName);
        RuleConfiguration currentRuleConfig = this.findCurrentRuleConfiguration(shardingSphereMetaData, ruleConfigClass).orElse(null);
        ruleDefinitionUpdater.checkSQLStatement(shardingSphereMetaData, sqlStatement, currentRuleConfig);
        Optional preprocessor = TypedSPIRegistry.findRegisteredService(RuleDefinitionAlterPreprocessor.class, (String)sqlStatement.getClass().getCanonicalName(), (Properties)new Properties());
        if (ProxyContext.getInstance().isScalingEnabled() && preprocessor.isPresent()) {
            this.processCache(shardingSphereMetaData, sqlStatement, (RuleDefinitionAlterUpdater)ruleDefinitionUpdater, currentRuleConfig, (RuleDefinitionAlterPreprocessor)preprocessor.get());
            return new UpdateResponseHeader((SQLStatement)sqlStatement);
        }
        this.processSQLStatement(shardingSphereMetaData, sqlStatement, ruleDefinitionUpdater, currentRuleConfig);
        this.persistRuleConfigurationChange(shardingSphereMetaData);
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private Optional<RuleConfiguration> findCurrentRuleConfiguration(ShardingSphereMetaData shardingSphereMetaData, Class<? extends RuleConfiguration> ruleConfigClass) {
        for (RuleConfiguration each : shardingSphereMetaData.getRuleMetaData().getConfigurations()) {
            if (!ruleConfigClass.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void processSQLStatement(ShardingSphereMetaData shardingSphereMetaData, T sqlStatement, RuleDefinitionUpdater updater, RuleConfiguration currentRuleConfig) {
        if (updater instanceof RuleDefinitionCreateUpdater) {
            this.processCreate(shardingSphereMetaData, sqlStatement, (RuleDefinitionCreateUpdater)updater, currentRuleConfig);
        } else if (updater instanceof RuleDefinitionAlterUpdater) {
            this.processAlter(sqlStatement, (RuleDefinitionAlterUpdater)updater, currentRuleConfig);
        } else if (updater instanceof RuleDefinitionDropUpdater) {
            this.processDrop(shardingSphereMetaData, sqlStatement, (RuleDefinitionDropUpdater)updater, currentRuleConfig);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot support RDL updater type `%s`", updater.getClass().getCanonicalName()));
        }
    }

    private void processCreate(ShardingSphereMetaData shardingSphereMetaData, T sqlStatement, RuleDefinitionCreateUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeCreatedRuleConfig = updater.buildToBeCreatedRuleConfiguration(sqlStatement);
        if (null == currentRuleConfig) {
            shardingSphereMetaData.getRuleMetaData().getConfigurations().add(toBeCreatedRuleConfig);
        } else {
            updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeCreatedRuleConfig);
        }
    }

    private void processAlter(T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeAlteredRuleConfig = updater.buildToBeAlteredRuleConfiguration(sqlStatement);
        updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void processDrop(ShardingSphereMetaData shardingSphereMetaData, T sqlStatement, RuleDefinitionDropUpdater updater, RuleConfiguration currentRuleConfig) {
        if (updater.updateCurrentRuleConfiguration(sqlStatement, currentRuleConfig)) {
            shardingSphereMetaData.getRuleMetaData().getConfigurations().remove(currentRuleConfig);
        }
    }

    private void processCache(ShardingSphereMetaData shardingSphereMetaData, T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig, RuleDefinitionAlterPreprocessor preprocessor) {
        RuleConfiguration toBeAlteredRuleConfig = updater.buildToBeAlteredRuleConfiguration(sqlStatement);
        RuleConfiguration alteredRuleConfig = preprocessor.preprocess(currentRuleConfig, toBeAlteredRuleConfig);
        LinkedList<RuleConfiguration> alteredConfigs = new LinkedList<RuleConfiguration>(shardingSphereMetaData.getRuleMetaData().getConfigurations());
        alteredConfigs.remove(currentRuleConfig);
        alteredConfigs.add(alteredRuleConfig);
        this.cacheRuleConfigurationChange(shardingSphereMetaData.getName(), alteredConfigs);
    }

    private void persistRuleConfigurationChange(ShardingSphereMetaData shardingSphereMetaData) {
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getSchemaRuleService().persist(shardingSphereMetaData.getName(), shardingSphereMetaData.getRuleMetaData().getConfigurations()));
    }

    private void cacheRuleConfigurationChange(String schemaName, Collection<RuleConfiguration> ruleConfigurations) {
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getSchemaRuleService().cache(schemaName, ruleConfigurations));
    }

    static {
        ShardingSphereServiceLoader.register(RuleDefinitionUpdater.class);
        ShardingSphereServiceLoader.register(RuleDefinitionAlterPreprocessor.class);
    }
}

