/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceParameter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;

public final class ResourceSegmentsConverter {
    public static Map<String, DataSourceConfiguration> convert(DatabaseType databaseType, Collection<DataSourceSegment> resources) {
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(resources.size(), 1.0f);
        for (DataSourceSegment each : resources) {
            DataSourceParameter dataSource = new DataSourceParameter();
            dataSource.setUrl(ResourceSegmentsConverter.getURL(databaseType, each));
            dataSource.setUsername(each.getUser());
            dataSource.setPassword(each.getPassword());
            dataSource.setCustomPoolProps(each.getProperties());
            result.put(each.getName(), ResourceSegmentsConverter.createDataSourceConfiguration(databaseType, each));
        }
        return result;
    }

    private static DataSourceConfiguration createDataSourceConfiguration(DatabaseType databaseType, DataSourceSegment segment) {
        DataSourceConfiguration result = new DataSourceConfiguration(HikariDataSource.class.getName());
        result.getProps().put("jdbcUrl", ResourceSegmentsConverter.getURL(databaseType, segment));
        result.getProps().put("username", segment.getUser());
        result.getProps().put("password", segment.getPassword());
        result.getProps().put("connectionTimeout", 30000L);
        result.getProps().put("idleTimeout", 60000L);
        result.getProps().put("maxLifetime", 1800000L);
        result.getProps().put("maximumPoolSize", 50);
        result.getProps().put("minimumIdle", 1);
        result.getProps().put("readOnly", false);
        if (null != segment.getProperties()) {
            result.getCustomPoolProps().putAll((Map<?, ?>)segment.getProperties());
        }
        return result;
    }

    private static String getURL(DatabaseType databaseType, DataSourceSegment dataSourceSegment) {
        if (null != dataSourceSegment.getUrl()) {
            return dataSourceSegment.getUrl();
        }
        return String.format("%s//%s:%s/%s", databaseType.getJdbcUrlPrefixes().iterator().next(), dataSourceSegment.getHostName(), dataSourceSegment.getPort(), dataSourceSegment.getDb());
    }

    @Generated
    private ResourceSegmentsConverter() {
    }
}

