/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.resource.ResourceDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.exception.resource.ResourceInUsedException;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.SchemaRequiredBackendHandler;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DropResourceBackendHandler
extends SchemaRequiredBackendHandler<DropResourceStatement> {
    public DropResourceBackendHandler(DropResourceStatement sqlStatement, BackendConnection backendConnection) {
        super(sqlStatement, backendConnection);
    }

    @Override
    public ResponseHeader execute(String schemaName, DropResourceStatement sqlStatement) throws ResourceDefinitionViolationException {
        Collection toBeDroppedResourceNames = sqlStatement.getNames();
        this.check(schemaName, toBeDroppedResourceNames, sqlStatement.isIgnoreSingleTables());
        this.drop(schemaName, toBeDroppedResourceNames);
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().drop(schemaName, toBeDroppedResourceNames));
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void check(String schemaName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables) throws RequiredResourceMissedException, ResourceInUsedException {
        this.checkResourceNameExisted(schemaName, toBeDroppedResourceNames);
        this.checkResourceNameNotInUse(schemaName, toBeDroppedResourceNames, ignoreSingleTables);
    }

    private void checkResourceNameExisted(String schemaName, Collection<String> resourceNames) throws RequiredResourceMissedException {
        Map resources = ProxyContext.getInstance().getMetaData(schemaName).getResource().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        if (!notExistedResourceNames.isEmpty()) {
            throw new RequiredResourceMissedException(schemaName, notExistedResourceNames);
        }
    }

    private void checkResourceNameNotInUse(String schemaName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables) throws ResourceInUsedException {
        Multimap<String, String> inUsedMultimap = this.getInUsedResources(schemaName);
        Set inUsedResourceNames = inUsedMultimap.keySet();
        inUsedResourceNames.retainAll(toBeDroppedResourceNames);
        if (!inUsedResourceNames.isEmpty()) {
            if (ignoreSingleTables) {
                this.checkResourceNameNotInUseIgnoreSingleTableRule(new HashSet<String>(inUsedResourceNames), inUsedMultimap);
            } else {
                String firstResource = (String)inUsedResourceNames.iterator().next();
                throw new ResourceInUsedException(firstResource, inUsedMultimap.get((Object)firstResource));
            }
        }
    }

    private void checkResourceNameNotInUseIgnoreSingleTableRule(Collection<String> inUsedResourceNames, Multimap<String, String> inUsedMultimap) throws ResourceInUsedException {
        for (String each : inUsedResourceNames) {
            Collection inUsedRules = inUsedMultimap.get((Object)each);
            inUsedRules.remove(SingleTableRule.class.getSimpleName());
            if (inUsedRules.isEmpty()) continue;
            throw new ResourceInUsedException(each, inUsedRules);
        }
    }

    private Multimap<String, String> getInUsedResources(String schemaName) {
        LinkedListMultimap result = LinkedListMultimap.create();
        for (ShardingSphereRule each : ProxyContext.getInstance().getMetaData(schemaName).getRuleMetaData().getRules()) {
            Set<String> inUsedResourceNames;
            if (each instanceof DataSourceContainedRule) {
                inUsedResourceNames = this.getInUsedResourceNames((DataSourceContainedRule)each);
                inUsedResourceNames.stream().forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$2((Multimap)result, each, arg_0));
            }
            if (!(each instanceof DataNodeContainedRule)) continue;
            inUsedResourceNames = this.getInUsedResourceNames((DataNodeContainedRule)each);
            inUsedResourceNames.stream().forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$3((Multimap)result, each, arg_0));
        }
        return result;
    }

    private Set<String> getInUsedResourceNames(DataSourceContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getDataSourceMapper().values()) {
            result.addAll(each);
        }
        return result;
    }

    private Set<String> getInUsedResourceNames(DataNodeContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getAllDataNodes().values()) {
            result.addAll(each.stream().map(DataNode::getDataSourceName).collect(Collectors.toList()));
        }
        return result;
    }

    private void drop(String schemaName, Collection<String> toBeDroppedResourceNames) {
        for (String each : toBeDroppedResourceNames) {
            ProxyContext.getInstance().getMetaData(schemaName).getResource().getDataSources().remove(each);
        }
    }

    private static /* synthetic */ void lambda$getInUsedResources$3(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }

    private static /* synthetic */ void lambda$getInUsedResources$2(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }
}

