/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfigurationValidator;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.DuplicateResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.SchemaRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.ResourceSegmentsConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlterResourceBackendHandler
extends SchemaRequiredBackendHandler<AlterResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlterResourceBackendHandler.class);
    private final DatabaseType databaseType;
    private final DataSourceConfigurationValidator dataSourceConfigValidator;

    public AlterResourceBackendHandler(DatabaseType databaseType, AlterResourceStatement sqlStatement, BackendConnection backendConnection) {
        super(sqlStatement, backendConnection);
        this.databaseType = databaseType;
        this.dataSourceConfigValidator = new DataSourceConfigurationValidator();
    }

    @Override
    public ResponseHeader execute(String schemaName, AlterResourceStatement sqlStatement) throws DistSQLException {
        this.checkSQLStatement(schemaName, sqlStatement);
        Map<String, DataSourceConfiguration> dataSourceConfigs = ResourceSegmentsConverter.convert(this.databaseType, sqlStatement.getDataSources());
        this.dataSourceConfigValidator.validate(dataSourceConfigs);
        try {
            ProxyContext.getInstance().getContextManager().alterResource(schemaName, dataSourceConfigs);
        }
        catch (SQLException ex) {
            log.error("Alter resource failed", (Throwable)ex);
            DistSQLException.predictionThrow((boolean)false, (DistSQLException)new InvalidResourcesException(dataSourceConfigs.keySet()));
        }
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().append(schemaName, dataSourceConfigs));
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void checkSQLStatement(String schemaName, AlterResourceStatement sqlStatement) throws DuplicateResourceException, RequiredResourceMissedException {
        Collection<String> toBeAlteredResourceNames = this.getToBeAlteredResourceNames(sqlStatement);
        this.checkToBeAlteredDuplicateResourceNames(toBeAlteredResourceNames);
        this.checkResourceNameExisted(schemaName, toBeAlteredResourceNames);
    }

    private Collection<String> getToBeAlteredResourceNames(AlterResourceStatement sqlStatement) {
        return sqlStatement.getDataSources().stream().map(DataSourceSegment::getName).collect(Collectors.toList());
    }

    private void checkToBeAlteredDuplicateResourceNames(Collection<String> resourceNames) throws DuplicateResourceException {
        Collection<String> duplicateResourceNames = this.getDuplicateResourceNames(resourceNames);
        if (!duplicateResourceNames.isEmpty()) {
            throw new DuplicateResourceException(duplicateResourceNames);
        }
    }

    private Collection<String> getDuplicateResourceNames(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> resourceNames.stream().filter(each::equals).count() > 1L).collect(Collectors.toList());
    }

    private void checkResourceNameExisted(String schemaName, Collection<String> resourceNames) throws RequiredResourceMissedException {
        Map resources = ProxyContext.getInstance().getMetaData(schemaName).getResource().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        if (!notExistedResourceNames.isEmpty()) {
            throw new RequiredResourceMissedException(schemaName, notExistedResourceNames);
        }
    }
}

