/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfigurationValidator;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.DuplicateResourceException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.SchemaRequiredBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.ResourceSegmentsConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddResourceBackendHandler
extends SchemaRequiredBackendHandler<AddResourceStatement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddResourceBackendHandler.class);
    private final DatabaseType databaseType;
    private final DataSourceConfigurationValidator dataSourceConfigValidator;

    public AddResourceBackendHandler(DatabaseType databaseType, AddResourceStatement sqlStatement, BackendConnection backendConnection) {
        super(sqlStatement, backendConnection);
        this.databaseType = databaseType;
        this.dataSourceConfigValidator = new DataSourceConfigurationValidator();
    }

    @Override
    public ResponseHeader execute(String schemaName, AddResourceStatement sqlStatement) throws DistSQLException {
        this.checkSQLStatement(schemaName, sqlStatement);
        Map<String, DataSourceConfiguration> dataSourceConfigs = ResourceSegmentsConverter.convert(this.databaseType, sqlStatement.getDataSources());
        this.dataSourceConfigValidator.validate(dataSourceConfigs);
        try {
            ProxyContext.getInstance().getContextManager().addResource(schemaName, dataSourceConfigs);
        }
        catch (SQLException ex) {
            log.error("Add resource failed", (Throwable)ex);
            DistSQLException.predictionThrow((boolean)false, (DistSQLException)new InvalidResourcesException(dataSourceConfigs.keySet()));
        }
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getDataSourceService().append(schemaName, dataSourceConfigs));
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void checkSQLStatement(String schemaName, AddResourceStatement sqlStatement) throws DuplicateResourceException {
        ArrayList<String> dataSourceNames = new ArrayList<String>(sqlStatement.getDataSources().size());
        HashSet<String> duplicateDataSourceNames = new HashSet<String>(sqlStatement.getDataSources().size(), 1.0f);
        for (DataSourceSegment each : sqlStatement.getDataSources()) {
            if (dataSourceNames.contains(each.getName()) || ProxyContext.getInstance().getMetaData(schemaName).getResource().getDataSources().containsKey(each.getName())) {
                duplicateDataSourceNames.add(each.getName());
            }
            dataSourceNames.add(each.getName());
        }
        if (!duplicateDataSourceNames.isEmpty()) {
            throw new DuplicateResourceException(duplicateDataSourceNames);
        }
    }
}

