/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RuleDefinitionStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.AddResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.AlterResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource.DropResourceBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule.RuleDefinitionBackendHandler;

public final class RDLBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(DatabaseType databaseType, RDLStatement sqlStatement, BackendConnection backendConnection) throws SQLException {
        return RDLBackendHandlerFactory.createBackendHandler(databaseType, sqlStatement, backendConnection);
    }

    private static TextProtocolBackendHandler createBackendHandler(DatabaseType databaseType, RDLStatement sqlStatement, BackendConnection backendConnection) {
        if (sqlStatement instanceof AddResourceStatement) {
            return new AddResourceBackendHandler(databaseType, (AddResourceStatement)sqlStatement, backendConnection);
        }
        if (sqlStatement instanceof AlterResourceStatement) {
            return new AlterResourceBackendHandler(databaseType, (AlterResourceStatement)sqlStatement, backendConnection);
        }
        if (sqlStatement instanceof DropResourceStatement) {
            return new DropResourceBackendHandler((DropResourceStatement)sqlStatement, backendConnection);
        }
        return new RuleDefinitionBackendHandler<RuleDefinitionStatement>((RuleDefinitionStatement)sqlStatement, backendConnection);
    }

    @Generated
    private RDLBackendHandlerFactory() {
    }
}

