/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.show.ShowVariableStatement;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor.AbstractShowExecutor;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;

public final class ShowVariableExecutor
extends AbstractShowExecutor {
    private final ShowVariableStatement sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        return Collections.singletonList(new QueryHeader("", "", this.sqlStatement.getName().toLowerCase(), this.sqlStatement.getName(), 12, "VARCHAR", 100, 0, false, false, false, false));
    }

    @Override
    protected MergedResult createMergedResult() {
        if (ConfigurationPropertyKey.getKeyNames().contains(this.sqlStatement.getName())) {
            ConfigurationProperties configurationProperties = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps();
            String propertyValue = configurationProperties.getValue((Enum)ConfigurationPropertyKey.valueOf((String)this.sqlStatement.getName())).toString();
            return new MultipleLocalDataMergedResult(Collections.singletonList(Collections.singletonList(propertyValue)));
        }
        VariableEnum variable = VariableEnum.getValueOf(this.sqlStatement.getName());
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                return new MultipleLocalDataMergedResult(Collections.singletonList(Collections.singletonList(SystemPropertyUtil.getSystemProperty(variable.name(), Boolean.FALSE.toString()))));
            }
            case CACHED_CONNECTIONS: {
                return new MultipleLocalDataMergedResult(Collections.singletonList(Collections.singletonList(this.backendConnection.getConnectionSize())));
            }
            case TRANSACTION_TYPE: {
                return new MultipleLocalDataMergedResult(Collections.singletonList(Collections.singletonList(this.backendConnection.getTransactionStatus().getTransactionType().name())));
            }
        }
        throw new UnsupportedVariableException(this.sqlStatement.getName());
    }

    @Generated
    public ShowVariableExecutor(ShowVariableStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }

    @Generated
    public ShowVariableStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }
}

