/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageStatusNode;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor.AbstractShowExecutor;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingReadResourcesStatement;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;

public final class ShowReadwriteSplittingReadResourcesExecutor
extends AbstractShowExecutor {
    private static final String DELIMITER = "\\.";
    private static final String RESOURCE = "resource";
    private static final String STATUS = "status";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private final ShowReadwriteSplittingReadResourcesStatement sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        return Arrays.asList(new QueryHeader("", "", RESOURCE, RESOURCE, 12, "VARCHAR", 64, 0, false, false, false, false), new QueryHeader("", "", STATUS, STATUS, 12, "VARCHAR", 64, 0, false, false, false, false));
    }

    @Override
    protected MergedResult createMergedResult() {
        String schemaName;
        String string = schemaName = this.sqlStatement.getSchema().isPresent() ? ((SchemaSegment)this.sqlStatement.getSchema().get()).getIdentifier().getValue() : this.backendConnection.getSchemaName();
        if (null == schemaName) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllSchemaNames().contains(schemaName)) {
            throw new SchemaNotExistedException(schemaName);
        }
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName);
        Collection<List<Object>> rows = this.buildResourceRows(metaData, ENABLE);
        MetaDataPersistService persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().orElse(null);
        if (null == persistService || null == persistService.getRepository()) {
            return new MultipleLocalDataMergedResult(rows);
        }
        Collection<List<Object>> disabledResourceRows = this.buildResourceRows(persistService, DISABLE);
        return new MultipleLocalDataMergedResult(this.mergeRows(rows, disabledResourceRows));
    }

    private Collection<List<Object>> buildResourceRows(ShardingSphereMetaData metaData, String status) {
        Set allResources = metaData.getResource().getDataSources().keySet();
        return allResources.stream().map(each -> this.buildRow((String)each, status)).collect(Collectors.toCollection(LinkedList::new));
    }

    private Collection<List<Object>> buildResourceRows(MetaDataPersistService persistService, String status) {
        List instanceIds = persistService.getRepository().getChildrenKeys(StorageStatusNode.getStatusPath((StorageNodeStatus)(status.equals(DISABLE) ? StorageNodeStatus.DISABLE : StorageNodeStatus.PRIMARY)));
        if (!instanceIds.isEmpty()) {
            return instanceIds.stream().filter(Objects::nonNull).map(each -> each.split(DELIMITER)[1]).map(each -> this.buildRow((String)each, status)).collect(Collectors.toCollection(LinkedList::new));
        }
        return Collections.emptyList();
    }

    private Collection<List<Object>> mergeRows(Collection<List<Object>> rows, Collection<List<Object>> disabledResourceRows) {
        Set disabledResourceNames = disabledResourceRows.stream().map(each -> this.getResourceName((List<Object>)each)).collect(Collectors.toSet());
        Collection result = rows.stream().filter(each -> !disabledResourceNames.contains(this.getResourceName((List<Object>)each))).collect(Collectors.toCollection(LinkedList::new));
        result.addAll(disabledResourceRows);
        return result;
    }

    private List<Object> buildRow(String resource, String status) {
        return Arrays.asList(resource, status);
    }

    private Object getResourceName(List<Object> row) {
        return row.get(0);
    }

    @Generated
    public ShowReadwriteSplittingReadResourcesExecutor(ShowReadwriteSplittingReadResourcesStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }
}

