/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.node.ComputeStatusNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.utils.IpUtils;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor.AbstractShowExecutor;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;

public final class ShowInstanceExecutor
extends AbstractShowExecutor {
    private static final String DELIMITER = "@";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String STATUS = "status";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        return Arrays.asList(new QueryHeader("", "", IP, IP, 12, "VARCHAR", 64, 0, false, false, false, false), new QueryHeader("", "", PORT, PORT, 12, "VARCHAR", 64, 0, false, false, false, false), new QueryHeader("", "", STATUS, STATUS, 12, "VARCHAR", 64, 0, false, false, false, false));
    }

    @Override
    protected MergedResult createMergedResult() {
        MetaDataPersistService persistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().orElse(null);
        if (null == persistService || null == persistService.getRepository()) {
            return new MultipleLocalDataMergedResult(this.buildInstanceRows());
        }
        Collection<List<Object>> rows = this.buildInstanceRows(persistService, ENABLE);
        Collection<List<Object>> disableInstanceIds = this.buildInstanceRows(persistService, DISABLE);
        if (!disableInstanceIds.isEmpty()) {
            rows.addAll(disableInstanceIds);
        }
        return new MultipleLocalDataMergedResult(rows);
    }

    private Collection<List<Object>> buildInstanceRows() {
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        String instanceId = String.join((CharSequence)DELIMITER, IpUtils.getIp(), " ");
        rows.add(this.buildRow(instanceId, ENABLE));
        return rows;
    }

    private Collection<List<Object>> buildInstanceRows(MetaDataPersistService persistService, String status) {
        String statusPath = ComputeStatusNode.getStatusPath((ComputeNodeStatus)(status.equals(ENABLE) ? ComputeNodeStatus.ONLINE : ComputeNodeStatus.CIRCUIT_BREAKER));
        List instanceIds = persistService.getRepository().getChildrenKeys(statusPath);
        if (!instanceIds.isEmpty()) {
            return instanceIds.stream().filter(Objects::nonNull).map(each -> this.buildRow((String)each, status)).collect(Collectors.toCollection(LinkedList::new));
        }
        return Collections.emptyList();
    }

    private List<Object> buildRow(String instanceId, String status) {
        LinkedList result = Arrays.stream(instanceId.split(DELIMITER)).map(each -> each).collect(Collectors.toCollection(LinkedList::new));
        result.add(status);
        return result;
    }
}

