/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor.AbstractShowExecutor;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;

public final class ShowAllVariablesExecutor
extends AbstractShowExecutor {
    private final BackendConnection backendConnection;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        LinkedList<QueryHeader> result = new LinkedList<QueryHeader>();
        result.add(new QueryHeader("", "", "variable_name", "variable_name", 12, "VARCHAR", 100, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "variable_value", "variable_value", 12, "VARCHAR", 100, 0, false, false, false, false));
        return result;
    }

    @Override
    protected MergedResult createMergedResult() {
        LinkedList<List<Object>> rows = new LinkedList<List<Object>>();
        ConfigurationProperties configurationProperties = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps();
        ConfigurationPropertyKey.getKeyNames().stream().forEach(each -> {
            String propertyValue = configurationProperties.getValue((Enum)ConfigurationPropertyKey.valueOf((String)each)).toString();
            rows.add(Arrays.asList(each.toLowerCase(), propertyValue));
        });
        rows.add(Arrays.asList(VariableEnum.AGENT_PLUGINS_ENABLED.name().toLowerCase(), SystemPropertyUtil.getSystemProperty(VariableEnum.AGENT_PLUGINS_ENABLED.name(), Boolean.FALSE.toString())));
        rows.add(Arrays.asList(VariableEnum.CACHED_CONNECTIONS.name().toLowerCase(), this.backendConnection.getConnectionSize()));
        rows.add(Arrays.asList(VariableEnum.TRANSACTION_TYPE.name().toLowerCase(), this.backendConnection.getTransactionStatus().getTransactionType().name()));
        return new MultipleLocalDataMergedResult(rows);
    }

    @Generated
    public ShowAllVariablesExecutor(BackendConnection backendConnection) {
        this.backendConnection = backendConnection;
    }
}

