/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.TextQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.show.ShowStatementExecutor;

public abstract class AbstractShowExecutor
implements ShowStatementExecutor {
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    @Override
    public final ResponseHeader execute() {
        this.queryHeaders = this.createQueryHeaders();
        this.mergedResult = this.createMergedResult();
        return new QueryResponseHeader(this.queryHeaders);
    }

    protected abstract List<QueryHeader> createQueryHeaders();

    protected abstract MergedResult createMergedResult();

    @Override
    public final boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public final QueryResponseRow getQueryResponseRow() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int i = 0; i < this.queryHeaders.size(); ++i) {
            cells.add(new TextQueryResponseCell(this.mergedResult.getValue(i + 1, Object.class)));
        }
        return new QueryResponseRow(cells);
    }
}

