/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.set.excutor;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.set.SetVariableStatement;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.properties.TypedPropertyKey;
import org.apache.shardingsphere.infra.properties.TypedPropertyValue;
import org.apache.shardingsphere.infra.properties.TypedPropertyValueException;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.enums.VariableEnum;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.InvalidValueException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.UnsupportedVariableException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.set.SetStatementExecutor;
import org.apache.shardingsphere.proxy.backend.util.SystemPropertyUtil;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class SetVariableExecutor
implements SetStatementExecutor {
    private final SetVariableStatement sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    public ResponseHeader execute() {
        Enum enumType = this.getEnumType(this.sqlStatement.getName());
        if (enumType instanceof ConfigurationPropertyKey) {
            this.handleConfigurationProperty((ConfigurationPropertyKey)enumType, this.sqlStatement.getValue());
        } else if (enumType instanceof VariableEnum) {
            this.handleVariables(this.sqlStatement);
        } else {
            throw new UnsupportedVariableException(this.sqlStatement.getName());
        }
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private Enum getEnumType(String name) {
        try {
            return ConfigurationPropertyKey.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return VariableEnum.getValueOf(name);
        }
    }

    private void handleConfigurationProperty(ConfigurationPropertyKey propertyKey, String value) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        Optional metaDataPersistService = metaDataContexts.getMetaDataPersistService();
        Properties props = metaDataContexts.getProps().getProps();
        props.put(propertyKey.getKey(), this.getValue(propertyKey, value));
        if (metaDataPersistService.isPresent() && null != ((MetaDataPersistService)metaDataPersistService.get()).getPropsService()) {
            ((MetaDataPersistService)metaDataPersistService.get()).getPropsService().persist(props, true);
        }
    }

    private Object getValue(ConfigurationPropertyKey propertyKey, String value) {
        try {
            TypedPropertyValue propertyValue = new TypedPropertyValue((TypedPropertyKey)propertyKey, value);
            return propertyValue.getValue();
        }
        catch (TypedPropertyValueException ex) {
            throw new InvalidValueException(value);
        }
    }

    private void handleVariables(SetVariableStatement setVariableStatement) {
        VariableEnum variable = VariableEnum.getValueOf(setVariableStatement.getName());
        switch (variable) {
            case AGENT_PLUGINS_ENABLED: {
                Boolean agentPluginsEnabled = BooleanUtils.toBooleanObject((String)this.sqlStatement.getValue());
                SystemPropertyUtil.setSystemProperty(variable.name(), null == agentPluginsEnabled ? Boolean.FALSE.toString() : agentPluginsEnabled.toString());
                break;
            }
            case TRANSACTION_TYPE: {
                this.backendConnection.getTransactionStatus().setTransactionType(this.getTransactionType(this.sqlStatement.getValue()));
                break;
            }
            default: {
                throw new UnsupportedVariableException(setVariableStatement.getName());
            }
        }
    }

    private TransactionType getTransactionType(String transactionTypeName) throws UnsupportedVariableException {
        try {
            return TransactionType.valueOf((String)transactionTypeName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedVariableException(transactionTypeName);
        }
    }

    @Generated
    public SetVariableExecutor(SetVariableStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }
}

