/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.set.excutor;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.set.SetStatementExecutor;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.status.SetReadwriteSplittingStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SetReadwriteSplittingStatusExecutor
implements SetStatementExecutor {
    private final SetReadwriteSplittingStatusStatement sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    public ResponseHeader execute() throws DistSQLException {
        String schemaName;
        String string = schemaName = this.sqlStatement.getSchema().isPresent() ? ((SchemaSegment)this.sqlStatement.getSchema().get()).getIdentifier().getValue() : this.backendConnection.getSchemaName();
        if (null == schemaName) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().getAllSchemaNames().contains(schemaName)) {
            throw new SchemaNotExistedException(schemaName);
        }
        String resourceName = this.sqlStatement.getResourceName();
        Collection notExistedResources = ProxyContext.getInstance().getMetaData(schemaName).getResource().getNotExistedResources(Collections.singleton(resourceName));
        DistSQLException.predictionThrow((boolean)notExistedResources.isEmpty(), (DistSQLException)new RequiredResourceMissedException(schemaName, Collections.singleton(resourceName)));
        ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, resourceName, "DISABLE".equals(this.sqlStatement.getStatus())));
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    @Generated
    public SetReadwriteSplittingStatusExecutor(SetReadwriteSplittingStatusStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }
}

