/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintShardingType;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.AbstractHintQueryExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.result.ShowShardingHintStatusResult;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ShowShardingHintStatusStatement;
import org.apache.shardingsphere.sharding.merge.dal.common.MultipleLocalDataMergedResult;

public final class ShowShardingHintStatusExecutor
extends AbstractHintQueryExecutor<ShowShardingHintStatusStatement> {
    private final BackendConnection backendConnection;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(4);
        result.add(new QueryHeader("", "", "table_name", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "database_sharding_values", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "table_sharding_values", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "sharding_type", "", 1, "CHAR", 255, 0, false, false, false, false));
        return result;
    }

    @Override
    protected MergedResult createMergedResult() {
        HashMap<String, ShowShardingHintStatusResult> results = new HashMap<String, ShowShardingHintStatusResult>();
        ShardingSphereMetaData metaData = ProxyContext.getInstance().getMetaData(this.backendConnection.getSchemaName());
        if (!metaData.isComplete()) {
            throw new RuleNotExistedException();
        }
        Collection tableNames = metaData.getSchema().getAllTableNames();
        for (String each : tableNames) {
            if (HintManager.isDatabaseShardingOnly()) {
                this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues(), Collections.emptyList());
                continue;
            }
            this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues((String)each), HintManager.getTableShardingValues((String)each));
        }
        return this.convertToMergedResult(results.values());
    }

    private void fillShardingValues(Map<String, ShowShardingHintStatusResult> results, String logicTable, Collection<Comparable<?>> databaseShardingValues, Collection<Comparable<?>> tableShardingValues) {
        if (!results.containsKey(logicTable)) {
            results.put(logicTable, new ShowShardingHintStatusResult(logicTable));
        }
        for (Comparable<?> each : databaseShardingValues) {
            results.get(logicTable).getDatabaseShardingValues().add(each.toString());
        }
        for (Comparable<?> each : tableShardingValues) {
            results.get(logicTable).getTableShardingValues().add(each.toString());
        }
    }

    private MergedResult convertToMergedResult(Collection<ShowShardingHintStatusResult> showShardingHintStatusResults) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>(showShardingHintStatusResults.size());
        for (ShowShardingHintStatusResult each : showShardingHintStatusResults) {
            values.add(this.createRow(each));
        }
        return new MultipleLocalDataMergedResult(values);
    }

    private List<Object> createRow(ShowShardingHintStatusResult showShardingHintStatusResult) {
        String shardingType = String.valueOf((Object)(HintManager.isDatabaseShardingOnly() ? HintShardingType.DATABASES_ONLY : HintShardingType.DATABASES_TABLES)).toLowerCase();
        ArrayList<Object> result = new ArrayList<Object>(3);
        result.add(showShardingHintStatusResult.getLogicTable());
        result.add(Joiner.on((String)",").join(showShardingHintStatusResult.getDatabaseShardingValues()));
        result.add(Joiner.on((String)",").join(showShardingHintStatusResult.getTableShardingValues()));
        result.add(shardingType);
        return result;
    }

    @Generated
    public ShowShardingHintStatusExecutor(BackendConnection backendConnection) {
        this.backendConnection = backendConnection;
    }
}

