/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint;

import com.mchange.v1.db.sql.UnsupportedTypeException;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.HintDistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.hint.ClearHintStatement;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintStatementExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.AddShardingHintDatabaseValueExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.AddShardingHintTableValueExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.ClearHintExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.ClearReadwriteSplittingHintExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.ClearShardingHintExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.SetReadwriteSplittingHintExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.SetShardingHintDatabaseValueExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.ShowReadwriteSplittingHintStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.executor.ShowShardingHintStatusExecutor;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.ClearReadwriteSplittingHintStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.SetReadwriteSplittingHintStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.hint.ShowReadwriteSplittingHintStatusStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.AddShardingHintDatabaseValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.AddShardingHintTableValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ClearShardingHintStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.SetShardingHintDatabaseValueStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ShowShardingHintStatusStatement;

public final class HintStatementExecutorFactory {
    public static HintStatementExecutor newInstance(HintDistSQLStatement sqlStatement, BackendConnection backendConnection) throws SQLException {
        if (sqlStatement instanceof SetReadwriteSplittingHintStatement) {
            return new SetReadwriteSplittingHintExecutor((SetReadwriteSplittingHintStatement)sqlStatement);
        }
        if (sqlStatement instanceof ShowReadwriteSplittingHintStatusStatement) {
            return new ShowReadwriteSplittingHintStatusExecutor();
        }
        if (sqlStatement instanceof ClearReadwriteSplittingHintStatement) {
            return new ClearReadwriteSplittingHintExecutor();
        }
        if (sqlStatement instanceof ClearHintStatement) {
            return new ClearHintExecutor();
        }
        if (sqlStatement instanceof SetShardingHintDatabaseValueStatement) {
            return new SetShardingHintDatabaseValueExecutor((SetShardingHintDatabaseValueStatement)sqlStatement);
        }
        if (sqlStatement instanceof AddShardingHintDatabaseValueStatement) {
            return new AddShardingHintDatabaseValueExecutor((AddShardingHintDatabaseValueStatement)sqlStatement);
        }
        if (sqlStatement instanceof AddShardingHintTableValueStatement) {
            return new AddShardingHintTableValueExecutor((AddShardingHintTableValueStatement)sqlStatement);
        }
        if (sqlStatement instanceof ShowShardingHintStatusStatement) {
            return new ShowShardingHintStatusExecutor(backendConnection);
        }
        if (sqlStatement instanceof ClearShardingHintStatement) {
            return new ClearShardingHintExecutor();
        }
        throw new UnsupportedTypeException(sqlStatement.getClass().getCanonicalName());
    }

    @Generated
    private HintStatementExecutorFactory() {
    }
}

