/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.CommonDistSQLException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.InvalidValueException;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.exception.UnsupportedVariableException;

public enum CommonDistSQLErrorCode implements SQLErrorCode
{
    UNSUPPORTED_VARIABLE(11002, "S11002", "Could not support variable [%s]."),
    INVALID_VALUE(11002, "S11002", "Invalid value [%s].");

    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public static CommonDistSQLErrorCode valueOf(CommonDistSQLException exception) {
        if (exception instanceof UnsupportedVariableException) {
            return UNSUPPORTED_VARIABLE;
        }
        if (exception instanceof InvalidValueException) {
            return INVALID_VALUE;
        }
        throw new UnsupportedOperationException("Cannot find common dist sql error code from exception: %s", exception);
    }

    @Generated
    private CommonDistSQLErrorCode(int errorCode, String sqlState, String errorMessage) {
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

