/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.common;

import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.common.HintDistSQLStatement;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintStatementExecutor;
import org.apache.shardingsphere.proxy.backend.text.distsql.ral.common.hint.HintStatementExecutorFactory;

public final class HintDistSQLBackendHandler
implements TextProtocolBackendHandler {
    private final HintDistSQLStatement sqlStatement;
    private final BackendConnection backendConnection;
    private HintStatementExecutor hintStatementExecutor;

    @Override
    public ResponseHeader execute() throws SQLException {
        if (!((Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_HINT_ENABLED)).booleanValue()) {
            throw new UnsupportedOperationException(String.format("%s should be true, please check your config", ConfigurationPropertyKey.PROXY_HINT_ENABLED.getKey()));
        }
        this.hintStatementExecutor = HintStatementExecutorFactory.newInstance(this.sqlStatement, this.backendConnection);
        return this.hintStatementExecutor.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.hintStatementExecutor.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.hintStatementExecutor.getQueryResponseRow().getData();
    }

    @Generated
    public HintDistSQLBackendHandler(HintDistSQLStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }

    @Generated
    public HintDistSQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    public HintStatementExecutor getHintStatementExecutor() {
        return this.hintStatementExecutor;
    }
}

