/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.ral.advanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.advanced.preview.PreviewStatement;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class PreviewDistSQLBackendHandler
implements TextProtocolBackendHandler {
    private final PreviewStatement previewStatement;
    private final BackendConnection backendConnection;
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private List<QueryHeader> queryHeaders;
    private Iterator<ExecutionUnit> executionUnits;

    @Override
    public ResponseHeader execute() {
        ShardingSphereMetaData metaData;
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String defaultSchemaName = this.backendConnection.getDefaultSchemaName();
        String databaseType = DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)metaDataContexts.getMetaData(defaultSchemaName).getResource().getDatabaseType());
        SQLStatement sqlStatement = new ShardingSphereSQLParserEngine(databaseType, metaDataContexts.getProps()).parse(this.previewStatement.getSql(), false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)metaDataContexts.getMetaDataMap(), Collections.emptyList(), (SQLStatement)sqlStatement, (String)defaultSchemaName);
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().ifPresent(SQLStatementSchemaHolder::set);
        }
        if (!(metaData = ProxyContext.getInstance().getMetaData(this.backendConnection.getSchemaName())).isComplete()) {
            throw new RuleNotExistedException();
        }
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, this.previewStatement.getSql(), Collections.emptyList());
        this.executionUnits = this.kernelProcessor.generateExecutionContext(logicSQL, metaData, metaDataContexts.getProps()).getExecutionUnits().iterator();
        this.queryHeaders = new ArrayList<QueryHeader>(2);
        this.queryHeaders.add(new QueryHeader("", "", "data_source_name", "", 1, "CHAR", 255, 0, false, false, false, false));
        this.queryHeaders.add(new QueryHeader("", "", "sql", "", 1, "CHAR", 255, 0, false, false, false, false));
        return new QueryResponseHeader(this.queryHeaders);
    }

    @Override
    public boolean next() {
        return null != this.executionUnits && this.executionUnits.hasNext();
    }

    @Override
    public Collection<Object> getRowData() {
        ExecutionUnit executionUnit = this.executionUnits.next();
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(executionUnit.getDataSourceName());
        result.add(executionUnit.getSqlUnit().getSql());
        return result;
    }

    @Generated
    public PreviewDistSQLBackendHandler(PreviewStatement previewStatement, BackendConnection backendConnection) {
        this.previewStatement = previewStatement;
        this.backendConnection = backendConnection;
    }

    @Generated
    public PreviewStatement getPreviewStatement() {
        return this.previewStatement;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    public KernelProcessor getKernelProcessor() {
        return this.kernelProcessor;
    }

    @Generated
    public List<QueryHeader> getQueryHeaders() {
        return this.queryHeaders;
    }

    @Generated
    public Iterator<ExecutionUnit> getExecutionUnits() {
        return this.executionUnits;
    }
}

