/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.database;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DBDropExistsException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;

public final class DropDatabaseBackendHandler
implements TextProtocolBackendHandler {
    private final DropDatabaseStatement sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    public ResponseHeader execute() {
        this.check(this.sqlStatement);
        if (this.isDropCurrentDatabase(this.sqlStatement.getDatabaseName())) {
            this.backendConnection.setCurrentSchema(null);
        }
        ProxyContext.getInstance().getContextManager().deleteSchema(this.sqlStatement.getDatabaseName());
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().delete(this.sqlStatement.getDatabaseName()));
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void check(DropDatabaseStatement sqlStatement) {
        if (!ProxyContext.getInstance().getAllSchemaNames().contains(sqlStatement.getDatabaseName())) {
            throw new DBDropExistsException(sqlStatement.getDatabaseName());
        }
    }

    private boolean isDropCurrentDatabase(String databaseName) {
        return !Strings.isNullOrEmpty((String)this.backendConnection.getSchemaName()) && this.backendConnection.getSchemaName().equals(databaseName);
    }

    @Generated
    public DropDatabaseBackendHandler(DropDatabaseStatement sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }
}

