/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.database;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.database.CreateDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.database.DropDatabaseBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;

public final class DatabaseOperateBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(SQLStatement sqlStatement, BackendConnection backendConnection) throws SQLException {
        return DatabaseOperateBackendHandlerFactory.createBackendHandler(sqlStatement, backendConnection);
    }

    private static TextProtocolBackendHandler createBackendHandler(SQLStatement sqlStatement, BackendConnection backendConnection) {
        if (sqlStatement instanceof CreateDatabaseStatement) {
            return new CreateDatabaseBackendHandler((CreateDatabaseStatement)sqlStatement);
        }
        if (sqlStatement instanceof DropDatabaseStatement) {
            return new DropDatabaseBackendHandler((DropDatabaseStatement)sqlStatement, backendConnection);
        }
        throw new UnsupportedOperationException(sqlStatement.getClass().getCanonicalName());
    }

    @Generated
    private DatabaseOperateBackendHandlerFactory() {
    }
}

