/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class UnicastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final BackendConnection backendConnection;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        String schemaName;
        String originSchema = this.backendConnection.getSchemaName();
        String string = schemaName = null == originSchema ? this.getFirstSchemaName() : originSchema;
        if (!ProxyContext.getInstance().getMetaData(schemaName).hasDataSource()) {
            throw new RuleNotExistedException();
        }
        try {
            this.backendConnection.setCurrentSchema(schemaName);
            this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.backendConnection);
            ResponseHeader responseHeader = this.databaseCommunicationEngine.execute();
            return responseHeader;
        }
        finally {
            this.backendConnection.setCurrentSchema(originSchema);
        }
    }

    private String getFirstSchemaName() {
        Collection<String> schemaNames = ProxyContext.getInstance().getAllSchemaNames();
        if (schemaNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<String> result = schemaNames.stream().filter(each -> ProxyContext.getInstance().getMetaData((String)each).hasDataSource()).findFirst();
        if (!result.isPresent()) {
            throw new RuleNotExistedException();
        }
        return result.get();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryResponseRow().getData();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.databaseCommunicationEngine) {
            this.databaseCommunicationEngine.close();
        }
    }

    @Generated
    public UnicastDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection backendConnection) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

