/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class SchemaAssignedDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final BackendConnection backendConnection;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    @Override
    public ResponseHeader execute() throws SQLException {
        if (!ProxyContext.getInstance().getMetaData(this.backendConnection.getSchemaName()).isComplete()) {
            throw new RuleNotExistedException();
        }
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.backendConnection);
        return this.databaseCommunicationEngine.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryResponseRow().getData();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.databaseCommunicationEngine) {
            this.databaseCommunicationEngine.close();
        }
    }

    @Generated
    public SchemaAssignedDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection backendConnection) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

