/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;

public final class BroadcastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final BackendConnection backendConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        List<String> schemaNames = this.getSchemaNamesWithDataSource().orElseThrow(DatabaseNotExistedException::new);
        String originalSchema = this.backendConnection.getSchemaName();
        try {
            for (String each : schemaNames) {
                this.backendConnection.setCurrentSchema(each);
                this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.sqlStatementContext, this.sql, this.backendConnection).execute();
            }
        }
        finally {
            this.backendConnection.setCurrentSchema(originalSchema);
        }
        return new UpdateResponseHeader(this.sqlStatementContext.getSqlStatement());
    }

    private Optional<List<String>> getSchemaNamesWithDataSource() {
        List result = ProxyContext.getInstance().getAllSchemaNames().stream().filter(each -> ProxyContext.getInstance().getMetaData((String)each).hasDataSource()).collect(Collectors.toList());
        return Optional.of(result).filter(each -> !each.isEmpty());
    }

    @Generated
    public BroadcastDatabaseBackendHandler(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection backendConnection) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

