/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.data;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.BroadcastDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.SchemaAssignedDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.UnicastDatabaseBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class DatabaseBackendHandlerFactory {
    public static DatabaseBackendHandler newInstance(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection backendConnection) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SetStatement || sqlStatement instanceof DCLStatement) {
            return new BroadcastDatabaseBackendHandler(sqlStatementContext, sql, backendConnection);
        }
        if (sqlStatement instanceof DALStatement || sqlStatement instanceof SelectStatement && null == ((SelectStatement)sqlStatement).getFrom()) {
            return new UnicastDatabaseBackendHandler(sqlStatementContext, sql, backendConnection);
        }
        return new SchemaAssignedDatabaseBackendHandler(sqlStatementContext, sql, backendConnection);
    }

    @Generated
    private DatabaseBackendHandlerFactory() {
    }
}

