/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information.AbstractSelectInformationExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SelectInformationSchemataExecutor
extends AbstractSelectInformationExecutor.DefaultSelectInformationExecutor {
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String DEFAULT_CHARACTER_SET_NAME = "DEFAULT_CHARACTER_SET_NAME";
    public static final String DEFAULT_COLLATION_NAME = "DEFAULT_COLLATION_NAME";
    public static final String CATALOG_NAME = "CATALOG_NAME";
    public static final String SQL_PATH = "SQL_PATH";
    public static final String DEFAULT_ENCRYPTION = "DEFAULT_ENCRYPTION";
    private static final Set<String> SCHEMA_WITHOUT_DATA_SOURCE = new LinkedHashSet<String>();
    private final SelectStatement sqlStatement;

    public SelectInformationSchemataExecutor(SelectStatement sqlStatement, String sql) {
        super(sql);
        this.sqlStatement = sqlStatement;
    }

    @Override
    protected List<String> getSchemaNames() {
        Collection<String> schemaNames = ProxyContext.getInstance().getAllSchemaNames();
        SCHEMA_WITHOUT_DATA_SOURCE.addAll(schemaNames.stream().filter(each -> AbstractSelectInformationExecutor.hasDatasource(each) == false).collect(Collectors.toSet()));
        List<String> result = schemaNames.stream().filter(AbstractSelectInformationExecutor::hasDatasource).collect(Collectors.toList());
        if (!SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            this.fillSchemasWithoutDatasource();
        }
        return result;
    }

    @Override
    protected void rowPostProcessing(String schemaName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        String alias;
        String rowValue;
        ShardingSphereResource resource = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getResource();
        Set catalogs = resource.getDataSources().keySet().stream().map(each -> resource.getDataSourcesMetaData().getDataSourceMetaData(each).getCatalog()).collect(Collectors.toSet());
        if (catalogs.contains(rowValue = rowMap.getOrDefault(alias = aliasMap.getOrDefault(SCHEMA_NAME, ""), "").toString())) {
            rowMap.replace(alias, schemaName);
        } else {
            rowMap.clear();
        }
    }

    private void fillSchemasWithoutDatasource() {
        if (SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            return;
        }
        Map<String, String> defaultRowData = this.getTheDefaultRowData();
        SCHEMA_WITHOUT_DATA_SOURCE.forEach(each -> {
            HashMap<String, String> row = new HashMap<String, String>(defaultRowData);
            row.replace(SCHEMA_NAME, (String)each);
            this.getRows().addLast(row);
        });
        SCHEMA_WITHOUT_DATA_SOURCE.clear();
    }

    private Map<String, String> getTheDefaultRowData() {
        Collection projections = this.sqlStatement.getProjections().getProjections();
        Map<String, String> result = projections.stream().anyMatch(each -> each instanceof ShorthandProjectionSegment) ? Stream.of(CATALOG_NAME, SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME, SQL_PATH, DEFAULT_ENCRYPTION).collect(Collectors.toMap(each -> each, each -> "")) : projections.stream().map(each -> ((ColumnProjectionSegment)each).getColumn().getIdentifier()).map(IdentifierValue::getValue).collect(Collectors.toMap(each -> each, each -> ""));
        return result;
    }
}

