/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseNotExistedException;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information.FunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectInformationExecutor
implements DatabaseAdminQueryExecutor {
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;
    private final LinkedList<Map<String, Object>> rows = new LinkedList();

    @Override
    public final void execute(BackendConnection backendConnection) throws SQLException {
        List<String> schemaNames = this.getSchemaNames();
        for (String schemaName : schemaNames) {
            this.getSourceData(schemaName, resultSet -> {
                while (resultSet.next()) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>();
                    HashMap<String, String> aliasMap = new HashMap<String, String>();
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                        aliasMap.put(metaData.getColumnName(i), metaData.getColumnLabel(i));
                        rowMap.put(metaData.getColumnLabel(i), resultSet.getString(i));
                    }
                    this.rowPostProcessing(schemaName, rowMap, aliasMap);
                    if (rowMap.isEmpty()) continue;
                    this.getRows().addFirst(rowMap);
                }
                return null;
            });
        }
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = this.createMergedResult();
    }

    protected abstract List<String> getSchemaNames();

    protected abstract void getSourceData(String var1, FunctionWithException<ResultSet, Void, SQLException> var2) throws SQLException;

    protected abstract void rowPostProcessing(String var1, Map<String, Object> var2, Map<String, String> var3);

    private MergedResult createMergedResult() {
        List resultDataRows = this.rows.stream().map(each -> new MemoryQueryResultDataRow(new LinkedList(each.values()))).collect(Collectors.toList());
        return new TransparentMergedResult((QueryResult)new RawMemoryQueryResult(this.queryResultMetaData, resultDataRows));
    }

    private RawQueryResultMetaData createQueryResultMetaData() {
        List columns = this.rows.stream().flatMap(each -> each.keySet().stream()).collect(Collectors.toSet()).stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    protected static Boolean hasDatasource(String schemaName) {
        return ProxyContext.getInstance().getMetaData(schemaName).hasDataSource();
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public LinkedList<Map<String, Object>> getRows() {
        return this.rows;
    }

    public static class DefaultSelectInformationExecutor
    extends AbstractSelectInformationExecutor {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DefaultSelectInformationExecutor.class);
        private final String sql;

        public DefaultSelectInformationExecutor(String sql) {
            this.sql = sql;
        }

        @Override
        protected List<String> getSchemaNames() {
            String schema = ProxyContext.getInstance().getAllSchemaNames().stream().filter(AbstractSelectInformationExecutor::hasDatasource).findFirst().orElseThrow(DatabaseNotExistedException::new);
            return Collections.singletonList(schema);
        }

        @Override
        protected void getSourceData(String schemaName, FunctionWithException<ResultSet, Void, SQLException> callback) throws SQLException {
            ShardingSphereResource resource = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getResource();
            Optional dataSourceEntry = resource.getDataSources().entrySet().stream().findFirst();
            log.info("Actual SQL: {} ::: {}", ((Map.Entry)dataSourceEntry.orElseThrow(DatabaseNotExistedException::new)).getKey(), (Object)this.sql);
            try (Connection conn = ((DataSource)((Map.Entry)dataSourceEntry.get()).getValue()).getConnection();
                 PreparedStatement ps = conn.prepareStatement(this.sql);){
                callback.apply(ps.executeQuery());
            }
        }

        @Override
        protected void rowPostProcessing(String schemaName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        }

        @Generated
        public String getSql() {
            return this.sql;
        }
    }
}

