/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class UseDatabaseExecutor
implements DatabaseAdminExecutor {
    private final UseStatement useStatement;

    @Override
    public void execute(BackendConnection backendConnection) {
        String schemaName = SQLUtil.getExactlyValue((String)this.useStatement.getSchema());
        if (!ProxyContext.getInstance().schemaExists(schemaName) && SQLCheckEngine.check((String)schemaName, this.getRules(schemaName), (Grantee)backendConnection.getGrantee())) {
            throw new UnknownDatabaseException(schemaName);
        }
        backendConnection.setCurrentSchema(schemaName);
    }

    private Collection<ShardingSphereRule> getRules(String schemaName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        Optional.ofNullable(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName)).ifPresent(each -> result.addAll(each.getRuleMetaData().getRules()));
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    public UseDatabaseExecutor(UseStatement useStatement) {
        this.useStatement = useStatement;
    }
}

