/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTableStatusStatement;

public final class ShowTablesStatusExecutor
implements DatabaseAdminQueryExecutor {
    private static final String NAME = "Name";
    private final MySQLShowTableStatusStatement showTablesStatement;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public void execute(BackendConnection backendConnection) {
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(backendConnection.getSchemaName()));
    }

    private QueryResult getQueryResult(String schemaName) {
        if (!ProxyContext.getInstance().getMetaData(schemaName).hasDataSource()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = ProxyContext.getInstance().getMetaData(schemaName).getSchema().getAllTableNames().stream().map(each -> new MemoryQueryResultDataRow(Collections.singletonList(each))).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private QueryResultMetaData createQueryResultMetaData() {
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("", NAME, NAME, 12, "VARCHAR", 255, 0)));
    }

    @Generated
    public ShowTablesStatusExecutor(MySQLShowTableStatusStatement showTablesStatement) {
        this.showTablesStatement = showTablesStatement;
    }

    @Generated
    public MySQLShowTableStatusStatement getShowTablesStatement() {
        return this.showTablesStatement;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

