/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class ShowTablesExecutor
implements DatabaseAdminQueryExecutor {
    private static final String TABLE_TYPE = "BASE TABLE";
    private final MySQLShowTablesStatement showTablesStatement;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public void execute(BackendConnection backendConnection) {
        this.queryResultMetaData = this.createQueryResultMetaData(backendConnection.getSchemaName());
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(backendConnection.getSchemaName()));
    }

    private QueryResult getQueryResult(String schemaName) {
        if (!ProxyContext.getInstance().getMetaData(schemaName).isComplete()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = this.getAllTableNames(schemaName).stream().map(each -> {
            LinkedList<String> rowValues = new LinkedList<String>();
            rowValues.add((String)each);
            rowValues.add(TABLE_TYPE);
            return new MemoryQueryResultDataRow(rowValues);
        }).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private Collection<String> getAllTableNames(String schemaName) {
        Collection allTableNames = ProxyContext.getInstance().getMetaData(schemaName).getSchema().getAllTableNames();
        Optional<String> pattern = this.showTablesStatement.getLike().map(each -> SQLUtil.convertLikePatternToRegex((String)each.getPattern()));
        return pattern.isPresent() ? (Collection)allTableNames.stream().filter(each -> each.matches((String)pattern.get())).collect(Collectors.toList()) : allTableNames;
    }

    private QueryResultMetaData createQueryResultMetaData(String schemaName) {
        LinkedList<RawQueryResultColumnMetaData> columnNames = new LinkedList<RawQueryResultColumnMetaData>();
        String tableColumnName = String.format("Tables_in_%s", schemaName);
        columnNames.add(new RawQueryResultColumnMetaData("", tableColumnName, tableColumnName, 12, "VARCHAR", 255, 0));
        columnNames.add(new RawQueryResultColumnMetaData("", "Table_type", "Table_type", 12, "VARCHAR", 20, 0));
        return new RawQueryResultMetaData(columnNames);
    }

    @Generated
    public ShowTablesExecutor(MySQLShowTablesStatement showTablesStatement) {
        this.showTablesStatement = showTablesStatement;
    }

    @Generated
    public MySQLShowTablesStatement getShowTablesStatement() {
        return this.showTablesStatement;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

