/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.sharding.merge.dal.common.SingleLocalDataMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;

public final class ShowDatabasesExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowDatabasesStatement showDatabasesStatement;
    private MergedResult mergedResult;

    @Override
    public void execute(BackendConnection backendConnection) {
        this.mergedResult = new SingleLocalDataMergedResult(this.getSchemaNames(backendConnection));
    }

    private Collection<Object> getSchemaNames(BackendConnection backendConnection) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (String each : ProxyContext.getInstance().getAllSchemaNames()) {
            if (!this.checkLikePattern(each) || !SQLCheckEngine.check((String)each, this.getRules(each), (Grantee)backendConnection.getGrantee())) continue;
            result.add(each);
        }
        return result;
    }

    private boolean checkLikePattern(String schemaName) {
        Optional<String> pattern = this.showDatabasesStatement.getLike().map(each -> SQLUtil.convertLikePatternToRegex((String)each.getPattern()));
        return !pattern.isPresent() || schemaName.matches(pattern.get());
    }

    private Collection<ShardingSphereRule> getRules(String schemaName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Override
    public QueryResultMetaData getQueryResultMetaData() {
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("SCHEMATA", "Database", "schema_name", 12, "VARCHAR", 255, 0)));
    }

    @Generated
    public ShowDatabasesExecutor(MySQLShowDatabasesStatement showDatabasesStatement) {
        this.showDatabasesStatement = showDatabasesStatement;
    }

    @Generated
    public MySQLShowDatabasesStatement getShowDatabasesStatement() {
        return this.showDatabasesStatement;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

