/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateDatabaseStatement;

public final class ShowCreateDatabaseExecutor
implements DatabaseAdminQueryExecutor {
    private static final String CREATE_DATABASE_PATTERN = "CREATE DATABASE `%s`;";
    private static final String DATABASE = "Database";
    private static final String CREATE_DATABASE = "CREATE DATABASE ";
    private final MySQLShowCreateDatabaseStatement showCreateDatabaseStatement;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public void execute(BackendConnection backendConnection) {
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(this.showCreateDatabaseStatement.getSchema()));
    }

    private QueryResult getQueryResult(String schemaName) {
        if (!ProxyContext.getInstance().schemaExists(schemaName)) {
            throw new SchemaNotExistedException(schemaName);
        }
        LinkedList<MemoryQueryResultDataRow> rows = new LinkedList<MemoryQueryResultDataRow>();
        rows.add(new MemoryQueryResultDataRow(Arrays.asList(schemaName, String.format(CREATE_DATABASE_PATTERN, schemaName))));
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private QueryResultMetaData createQueryResultMetaData() {
        List<RawQueryResultColumnMetaData> columnMetaData = Arrays.asList(new RawQueryResultColumnMetaData("", DATABASE, DATABASE, 12, "VARCHAR", 255, 0), new RawQueryResultColumnMetaData("", CREATE_DATABASE, CREATE_DATABASE, 12, "VARCHAR", 255, 0));
        return new RawQueryResultMetaData(columnMetaData);
    }

    @Generated
    public ShowCreateDatabaseExecutor(MySQLShowCreateDatabaseStatement showCreateDatabaseStatement) {
        this.showCreateDatabaseStatement = showCreateDatabaseStatement;
    }

    @Generated
    public MySQLShowCreateDatabaseStatement getShowCreateDatabaseStatement() {
        return this.showCreateDatabaseStatement;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

