/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql;

import java.util.Arrays;
import java.util.List;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information.AbstractSelectInformationExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information.SelectInformationSchemataExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLInformationSchemaExecutorFactory {
    public static final String SCHEMATA_TABLE = "SCHEMATA";
    public static final List<String> DEFAULT_EXECUTOR_TABLES = Arrays.asList("ENGINES", "FILES", "VIEWS", "TRIGGERS", "PARTITIONS");

    public static DatabaseAdminQueryExecutor newInstance(SelectStatement sqlStatement, String sql) {
        String tableName = ((SimpleTableSegment)sqlStatement.getFrom()).getTableName().getIdentifier().getValue();
        if (SCHEMATA_TABLE.equalsIgnoreCase(tableName)) {
            return new SelectInformationSchemataExecutor(sqlStatement, sql);
        }
        if (DEFAULT_EXECUTOR_TABLES.contains(tableName.toUpperCase())) {
            return new AbstractSelectInformationExecutor.DefaultSelectInformationExecutor(sql);
        }
        throw new UnsupportedOperationException(String.format("unsupported table : `%s`", tableName));
    }
}

