/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql;

import java.util.Optional;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorFactory;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.MySQLInformationSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowConnectionIdExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCreateDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCurrentDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCurrentUserExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowDatabasesExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowFunctionStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowProcedureStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowProcessListExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowTablesExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowTablesStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowVersionExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.UseDatabaseExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class MySQLAdminExecutorFactory
implements DatabaseAdminExecutorFactory {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String PERFORMANCE_SCHEMA = "performance_schema";

    @Override
    public Optional<DatabaseAdminExecutor> newInstance(SQLStatement sqlStatement) {
        if (sqlStatement instanceof MySQLShowFunctionStatusStatement) {
            return Optional.of(new ShowFunctionStatusExecutor((MySQLShowFunctionStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcedureStatusStatement) {
            return Optional.of(new ShowProcedureStatusExecutor((MySQLShowProcedureStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowTablesStatement) {
            return Optional.of(new ShowTablesExecutor((MySQLShowTablesStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowTableStatusStatement) {
            return Optional.of(new ShowTablesStatusExecutor((MySQLShowTableStatusStatement)sqlStatement));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatabaseAdminExecutor> newInstance(SQLStatement sqlStatement, String sql) {
        if (sqlStatement instanceof UseStatement) {
            return Optional.of(new UseDatabaseExecutor((UseStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowDatabasesStatement) {
            return Optional.of(new ShowDatabasesExecutor((MySQLShowDatabasesStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcessListStatement) {
            return Optional.of(new ShowProcessListExecutor());
        }
        if (sqlStatement instanceof MySQLShowCreateDatabaseStatement) {
            return Optional.of(new ShowCreateDatabaseExecutor((MySQLShowCreateDatabaseStatement)sqlStatement));
        }
        if (sqlStatement instanceof SelectStatement) {
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "connection_id()")) {
                return Optional.of(new ShowConnectionIdExecutor());
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "version()")) {
                return Optional.of(new ShowVersionExecutor());
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "current_user()")) {
                return Optional.of(new ShowCurrentUserExecutor());
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "DATABASE()")) {
                return Optional.of(new ShowCurrentDatabaseExecutor());
            }
            if (this.isQueryInformationSchema((SelectStatement)sqlStatement)) {
                return Optional.of(MySQLInformationSchemaExecutorFactory.newInstance((SelectStatement)sqlStatement, sql));
            }
            if (this.isQueryPerformanceSchema((SelectStatement)sqlStatement)) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private boolean isShowSpecialFunction(SelectStatement sqlStatement, String functionName) {
        ProjectionSegment firstProjection = (ProjectionSegment)sqlStatement.getProjections().getProjections().iterator().next();
        return firstProjection instanceof ExpressionProjectionSegment && functionName.equalsIgnoreCase(((ExpressionProjectionSegment)firstProjection).getText());
    }

    private boolean isQueryInformationSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, INFORMATION_SCHEMA);
    }

    private boolean isQueryPerformanceSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, PERFORMANCE_SCHEMA);
    }

    private boolean isQuerySpecialSchema(SelectStatement sqlStatement, String specialSchemaName) {
        TableSegment tableSegment = sqlStatement.getFrom();
        if (!(tableSegment instanceof SimpleTableSegment)) {
            return false;
        }
        return ((SimpleTableSegment)tableSegment).getOwner().isPresent() && specialSchemaName.equalsIgnoreCase(((OwnerSegment)((SimpleTableSegment)tableSegment).getOwner().get()).getIdentifier().getValue());
    }

    public String getType() {
        return "MySQL";
    }
}

