/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeaderBuilder;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;

public final class DatabaseAdminQueryBackendHandler
implements TextProtocolBackendHandler {
    private final BackendConnection backendConnection;
    private final DatabaseAdminQueryExecutor executor;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.executor.execute(this.backendConnection);
        this.queryResultMetaData = this.executor.getQueryResultMetaData();
        this.mergedResult = this.executor.getMergedResult();
        return new QueryResponseHeader(this.createResponseHeader());
    }

    private List<QueryHeader> createResponseHeader() throws SQLException {
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(this.queryResultMetaData.getColumnCount());
        ShardingSphereMetaData metaData = null == this.backendConnection.getSchemaName() ? null : ProxyContext.getInstance().getMetaData(this.backendConnection.getSchemaName());
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(QueryHeaderBuilder.build(this.queryResultMetaData, metaData, columnIndex));
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return result;
    }

    @Generated
    public DatabaseAdminQueryBackendHandler(BackendConnection backendConnection, DatabaseAdminQueryExecutor executor) {
        this.backendConnection = backendConnection;
        this.executor = executor;
    }
}

