/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminQueryBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminUpdateBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorFactory;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DatabaseAdminBackendHandlerFactory {
    public static Optional<TextProtocolBackendHandler> newInstance(DatabaseType databaseType, SQLStatement sqlStatement, BackendConnection backendConnection) {
        Optional executorFactory = TypedSPIRegistry.findRegisteredService(DatabaseAdminExecutorFactory.class, (String)databaseType.getName(), (Properties)new Properties());
        if (!executorFactory.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = ((DatabaseAdminExecutorFactory)executorFactory.get()).newInstance(sqlStatement);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createTextProtocolBackendHandler(sqlStatement, backendConnection, optional));
    }

    public static Optional<TextProtocolBackendHandler> newInstance(DatabaseType databaseType, SQLStatement sqlStatement, BackendConnection backendConnection, String sql) {
        Optional executorFactory = TypedSPIRegistry.findRegisteredService(DatabaseAdminExecutorFactory.class, (String)databaseType.getName(), (Properties)new Properties());
        if (!executorFactory.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = ((DatabaseAdminExecutorFactory)executorFactory.get()).newInstance(sqlStatement, sql);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createTextProtocolBackendHandler(sqlStatement, backendConnection, optional));
    }

    private static TextProtocolBackendHandler createTextProtocolBackendHandler(SQLStatement sqlStatement, BackendConnection backendConnection, DatabaseAdminExecutor executor) {
        return executor instanceof DatabaseAdminQueryExecutor ? new DatabaseAdminQueryBackendHandler(backendConnection, (DatabaseAdminQueryExecutor)executor) : new DatabaseAdminUpdateBackendHandler(backendConnection, sqlStatement, executor);
    }

    @Generated
    private DatabaseAdminBackendHandlerFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseAdminExecutorFactory.class);
    }
}

