/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementSchemaHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.database.DatabaseOperateBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.distsql.DistSQLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.extra.ExtraTextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.skip.SkipBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionBackendHandlerFactory;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class TextProtocolBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(DatabaseType databaseType, String sql, BackendConnection backendConnection) throws SQLException {
        Optional<ExtraTextProtocolBackendHandler> extraHandler;
        String trimSQL = SQLUtil.trimComment((String)sql);
        if (Strings.isNullOrEmpty((String)trimSQL)) {
            return new SkipBackendHandler((SQLStatement)new EmptyStatement());
        }
        SQLStatement sqlStatement = new ShardingSphereSQLParserEngine(TextProtocolBackendHandlerFactory.getBackendDatabaseType(databaseType, backendConnection).getName(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps()).parse(sql, false);
        if (sqlStatement instanceof DistSQLStatement) {
            return DistSQLBackendHandlerFactory.newInstance(databaseType, (DistSQLStatement)sqlStatement, backendConnection);
        }
        Optional<TextProtocolBackendHandler> backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatement, backendConnection, sql);
        if (backendHandler.isPresent()) {
            return backendHandler.get();
        }
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap(), Collections.emptyList(), (SQLStatement)sqlStatement, (String)backendConnection.getDefaultSchemaName());
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().ifPresent(SQLStatementSchemaHolder::set);
        }
        if ((extraHandler = TextProtocolBackendHandlerFactory.findExtraTextProtocolBackendHandler(sqlStatement)).isPresent()) {
            return extraHandler.get();
        }
        String schemaName = backendConnection.getSchemaName();
        SQLCheckEngine.check((SQLStatement)sqlStatement, Collections.emptyList(), TextProtocolBackendHandlerFactory.getRules(schemaName), (String)schemaName, (Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap(), (Grantee)backendConnection.getGrantee());
        if (sqlStatement instanceof TCLStatement) {
            return TransactionBackendHandlerFactory.newInstance((SQLStatementContext<? extends TCLStatement>)sqlStatementContext, sql, backendConnection);
        }
        if (sqlStatement instanceof CreateDatabaseStatement || sqlStatement instanceof DropDatabaseStatement) {
            return DatabaseOperateBackendHandlerFactory.newInstance(sqlStatement, backendConnection);
        }
        backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatement, backendConnection);
        return backendHandler.orElseGet(() -> DatabaseBackendHandlerFactory.newInstance(sqlStatementContext, sql, backendConnection));
    }

    private static DatabaseType getBackendDatabaseType(DatabaseType defaultDatabaseType, BackendConnection backendConnection) {
        String schemaName = backendConnection.getSchemaName();
        return Strings.isNullOrEmpty((String)schemaName) || !ProxyContext.getInstance().schemaExists(schemaName) ? defaultDatabaseType : ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(schemaName).getResource().getDatabaseType();
    }

    private static Optional<ExtraTextProtocolBackendHandler> findExtraTextProtocolBackendHandler(SQLStatement sqlStatement) {
        return ShardingSphereServiceLoader.getSingletonServiceInstances(ExtraTextProtocolBackendHandler.class).stream().filter(each -> each.accept(sqlStatement)).findFirst();
    }

    private static Collection<ShardingSphereRule> getRules(String schemaName) {
        MetaDataContexts contexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (Strings.isNullOrEmpty((String)schemaName) || !ProxyContext.getInstance().schemaExists(schemaName)) {
            return contexts.getGlobalRuleMetaData().getRules();
        }
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(contexts.getMetaData(schemaName).getRuleMetaData().getRules());
        result.addAll(contexts.getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    private TextProtocolBackendHandlerFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(ExtraTextProtocolBackendHandler.class);
    }
}

