/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.available.FromSchemaAvailable;

public abstract class SchemaRequiredBackendHandler<T extends SQLStatement>
implements TextProtocolBackendHandler {
    private final T sqlStatement;
    private final BackendConnection backendConnection;

    @Override
    public final ResponseHeader execute() throws SQLException {
        String schemaName = this.getSchemaName(this.backendConnection, this.sqlStatement);
        this.checkSchema(schemaName);
        return this.execute(schemaName, this.sqlStatement);
    }

    protected abstract ResponseHeader execute(String var1, T var2) throws SQLException;

    private String getSchemaName(BackendConnection backendConnection, T sqlStatement) {
        Optional schemaFromSQL = sqlStatement instanceof FromSchemaAvailable ? ((FromSchemaAvailable)sqlStatement).getSchema() : Optional.empty();
        return schemaFromSQL.isPresent() ? ((SchemaSegment)schemaFromSQL.get()).getIdentifier().getValue() : backendConnection.getSchemaName();
    }

    private void checkSchema(String schemaName) {
        if (null == schemaName) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().schemaExists(schemaName)) {
            throw new UnknownDatabaseException(schemaName);
        }
    }

    @Generated
    public SchemaRequiredBackendHandler(T sqlStatement, BackendConnection backendConnection) {
        this.sqlStatement = sqlStatement;
        this.backendConnection = backendConnection;
    }

    @Generated
    public T getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }
}

