/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.query.impl;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;

public final class QueryHeaderBuilder {
    public static QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereMetaData metaData, int columnIndex) throws SQLException {
        return QueryHeaderBuilder.build(queryResultMetaData, metaData, queryResultMetaData.getColumnName(columnIndex), columnIndex);
    }

    public static QueryHeader build(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, ShardingSphereMetaData metaData, int columnIndex) throws SQLException {
        return QueryHeaderBuilder.build(queryResultMetaData, metaData, QueryHeaderBuilder.getColumnName(projectionsContext, queryResultMetaData, columnIndex), columnIndex);
    }

    private static QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereMetaData metaData, String columnName, int columnIndex) throws SQLException {
        boolean primaryKey;
        String tableName;
        Optional dataNodeContainedRule;
        String schemaName = null == metaData ? "" : metaData.getName();
        String actualTableName = queryResultMetaData.getTableName(columnIndex);
        Optional<Object> optional = dataNodeContainedRule = null == metaData ? Optional.empty() : metaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataNodeContainedRule).findFirst().map(rule -> (DataNodeContainedRule)rule);
        if (null != actualTableName && dataNodeContainedRule.isPresent()) {
            tableName = ((DataNodeContainedRule)dataNodeContainedRule.get()).findLogicTableByActualTable(actualTableName).orElse("");
            TableMetaData tableMetaData = metaData.getSchema().get(tableName);
            primaryKey = null != tableMetaData && Optional.ofNullable(tableMetaData.getColumns().get(columnName.toLowerCase())).map(ColumnMetaData::isPrimaryKey).orElse(false) != false;
        } else {
            tableName = actualTableName;
            primaryKey = false;
        }
        String columnLabel = queryResultMetaData.getColumnLabel(columnIndex);
        int columnType = queryResultMetaData.getColumnType(columnIndex);
        String columnTypeName = queryResultMetaData.getColumnTypeName(columnIndex);
        int columnLength = queryResultMetaData.getColumnLength(columnIndex);
        int decimals = queryResultMetaData.getDecimals(columnIndex);
        boolean signed = queryResultMetaData.isSigned(columnIndex);
        boolean notNull = queryResultMetaData.isNotNull(columnIndex);
        boolean autoIncrement = queryResultMetaData.isAutoIncrement(columnIndex);
        return new QueryHeader(schemaName, tableName, columnLabel, columnName, columnType, columnTypeName, columnLength, decimals, signed, primaryKey, notNull, autoIncrement);
    }

    private static String getColumnName(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, int columnIndex) throws SQLException {
        Projection projection = (Projection)projectionsContext.getExpandProjections().get(columnIndex - 1);
        return projection instanceof ColumnProjection ? ((ColumnProjection)projection).getName() : queryResultMetaData.getColumnName(columnIndex);
    }

    @Generated
    private QueryHeaderBuilder() {
    }
}

