/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.context;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.datasource.JDBCBackendDataSource;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.scaling.core.api.ScalingWorker;

public final class ProxyContext {
    private static final ProxyContext INSTANCE = new ProxyContext();
    private final JDBCBackendDataSource backendDataSource = new JDBCBackendDataSource();
    private volatile ContextManager contextManager = new ContextManager();

    public static ProxyContext getInstance() {
        return INSTANCE;
    }

    public void init(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public boolean schemaExists(String schemaName) {
        return this.contextManager.getMetaDataContexts().getAllSchemaNames().contains(schemaName);
    }

    public ShardingSphereMetaData getMetaData(String schemaName) {
        if (Strings.isNullOrEmpty((String)schemaName) || !this.contextManager.getMetaDataContexts().getAllSchemaNames().contains(schemaName)) {
            throw new NoDatabaseSelectedException();
        }
        return this.contextManager.getMetaDataContexts().getMetaData(schemaName);
    }

    public Collection<String> getAllSchemaNames() {
        return this.contextManager.getMetaDataContexts().getAllSchemaNames();
    }

    public Optional<ShardingSphereLock> getLock() {
        return Optional.empty();
    }

    public StateContext getStateContext() {
        return this.contextManager.getStateContext();
    }

    public Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        if (!Strings.isNullOrEmpty((String)databaseName) && this.schemaExists(databaseName)) {
            result.addAll(this.contextManager.getMetaDataContexts().getMetaData(databaseName).getRuleMetaData().getRules());
        }
        result.addAll(this.contextManager.getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    public boolean isScalingEnabled() {
        return ScalingWorker.isEnabled();
    }

    @Generated
    private ProxyContext() {
    }

    @Generated
    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }
}

