/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class TransactionStatus {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 200L;
    private static final int MAXIMUM_RETRY_COUNT = 5;
    private volatile boolean inTransaction;
    private volatile TransactionType transactionType;

    public TransactionStatus(TransactionType initialTransactionType) {
        this.transactionType = initialTransactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        if (this.inTransaction) {
            throw new ShardingSphereException("Failed to switch transaction type, please terminate current transaction.", new Object[0]);
        }
        this.transactionType = transactionType;
    }

    public boolean isInConnectionHeldTransaction() {
        return this.inTransaction && TransactionType.BASE != this.transactionType;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public void setInTransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }
}

