/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.ConnectionSavepointManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.TransactionManager;

public final class LocalTransactionManager
implements TransactionManager {
    private final BackendConnection connection;

    @Override
    public void begin() {
        this.connection.getConnectionPostProcessors().add(target -> {
            try {
                target.setAutoCommit(false);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection.getTransactionStatus().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>(this.commitConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SQLException> commitConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
            finally {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
        return result;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection.getTransactionStatus().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>(this.rollbackConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SQLException> rollbackConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
            finally {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
        return result;
    }

    @Override
    public void setSavepoint(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        for (Connection each : this.connection.getCachedConnections().values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.connection.getConnectionPostProcessors().add(target -> {
            try {
                ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Override
    public void rollbackTo(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(result);
    }

    @Override
    public void releaseSavepoint(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(result);
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("");
        exceptions.forEach(ex::setNextException);
        throw ex;
    }

    @Generated
    public LocalTransactionManager(BackendConnection connection) {
        this.connection = connection;
    }
}

