/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction;

import java.sql.SQLException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.LocalTransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.TransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.TransactionHolder;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;

public final class BackendTransactionManager
implements TransactionManager {
    private final BackendConnection connection;
    private final TransactionType transactionType;
    private final LocalTransactionManager localTransactionManager;
    private final ShardingSphereTransactionManager shardingSphereTransactionManager;

    public BackendTransactionManager(BackendConnection backendConnection) {
        this.connection = backendConnection;
        this.transactionType = this.connection.getTransactionStatus().getTransactionType();
        this.localTransactionManager = new LocalTransactionManager(backendConnection);
        ShardingSphereTransactionManagerEngine engine = (ShardingSphereTransactionManagerEngine)ProxyContext.getInstance().getContextManager().getTransactionContexts().getEngines().get(this.connection.getSchemaName());
        this.shardingSphereTransactionManager = null == engine ? null : engine.getTransactionManager(this.transactionType);
    }

    @Override
    public void begin() {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            this.connection.getTransactionStatus().setInTransaction(true);
            TransactionHolder.setInTransaction();
            this.connection.closeDatabaseCommunicationEngines(true);
            this.connection.closeConnections(false);
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
            this.localTransactionManager.begin();
        } else {
            this.shardingSphereTransactionManager.begin();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection.getTransactionStatus().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
                    this.localTransactionManager.commit();
                } else {
                    this.shardingSphereTransactionManager.commit();
                }
            }
            finally {
                this.connection.getTransactionStatus().setInTransaction(false);
                TransactionHolder.clear();
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection.getTransactionStatus().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
                    this.localTransactionManager.rollback();
                } else {
                    this.shardingSphereTransactionManager.rollback();
                }
            }
            finally {
                this.connection.getTransactionStatus().setInTransaction(false);
                TransactionHolder.clear();
            }
        }
    }

    @Override
    public void setSavepoint(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
            this.localTransactionManager.setSavepoint(savepointName);
        }
    }

    @Override
    public void rollbackTo(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
            this.localTransactionManager.rollbackTo(savepointName);
        }
    }

    @Override
    public void releaseSavepoint(String savepointName) throws SQLException {
        if (!this.connection.getTransactionStatus().isInTransaction()) {
            return;
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
            this.localTransactionManager.releaseSavepoint(savepointName);
        }
    }
}

